/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP2417
extends AssertionProcessVisitor {
    private final WSDLValidatorImpl validator;
    private ErrorList errorList = new ErrorList();
    private static final String NS_LIST_KEY = "namespaces";

    public BP2417(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    private void checkNamespace(QName qName, WSDLTraversalContext wSDLTraversalContext) {
        List list;
        String string;
        if (qName != null && (string = qName.getNamespaceURI()) != null && (list = (List)wSDLTraversalContext.getParameter(NS_LIST_KEY)) != null && !list.contains(string)) {
            this.errorList.add(qName);
        }
    }

    public void visit(Message message, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (message != null) {
            Map map = message.getParts();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                this.checkNamespace(part.getElementName(), wSDLTraversalContext);
                this.checkNamespace(part.getTypeName(), wSDLTraversalContext);
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        Vector<String> vector = null;
        try {
            vector = this.validator.getSchemaNamespaceList(definition);
            if (vector == null) {
                vector = new Vector();
            }
        }
        catch (WSIException wSIException) {
            vector = new Vector<String>();
        }
        vector.add("http://www.w3.org/2001/XMLSchema");
        HashMap<String, Vector<String>> hashMap = new HashMap<String, Vector<String>>();
        hashMap.put(NS_LIST_KEY, vector);
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitMessage(true);
        wSDLTraversal.ignoreImport();
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.traverse(definition, hashMap);
        if (this.errorList.isEmpty()) {
            this.result = "passed";
        } else {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errorList.toString(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

