/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.test.util.StringTokenizer;
import org.wsi.xml.XMLTags;
import org.wsi.xml.XMLUtils;

public class BP2202
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private boolean importFound = false;
    private final char[] OMMITED_XML_DECLARATION_DELIMITERS = new char[]{' ', '\t', '\r', '\n', '\'', '\"'};
    private final char[] XML_DECLARATION_DELIMITERS = new char[]{'='};
    private final String UTF_8_ENCODING = "UTF-8";
    private final String UTF_16_ENCODING = "UTF-16";
    private final String ENCODING_TOKEN = "encoding";
    private final String VERSION_TOKEN = "version";

    public BP2202(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "notApplicable";
        this.result = "notApplicable";
        Types types = (Types)entryContext.getEntry().getEntryDetail();
        List list = null;
        if (types != null) {
            list = types.getExtensibilityElements();
        }
        if (list != null) {
            Definition definition = null;
            definition = this.validator.analyzerContext.getCandidateInfo().getDefinition(types);
            if (definition == null) {
                throw new WSIException("Could not find types definition in any WSDL document.");
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                if (!(extensibilityElement instanceof UnknownExtensibilityElement) || !extensibilityElement.getElementType().equals(XMLTags.ELEM_XSD_SCHEMA)) continue;
                this.searchForSchema(((UnknownExtensibilityElement)extensibilityElement).getElement(), definition.getDocumentBaseURI());
            }
        }
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.importFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void searchForSchema(Node node, String string) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                if (XMLUtils.equals(node, XMLTags.ELEM_XSD_SCHEMA)) {
                    this.processSchema(node, string);
                } else if (XMLUtils.equals(node, XMLTags.ELEM_XSD_IMPORT)) {
                    this.importFound = true;
                    this.loadSchema(node, string);
                } else {
                    this.searchForSchema(node.getFirstChild(), string);
                }
            }
            node = node.getNextSibling();
        }
    }

    private void loadSchema(Node node, String string) {
        Element element = (Element)node;
        Attr attr = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_SCHEMALOCATION);
        if (attr != null && attr.getValue() != null) {
            try {
                Node node2;
                String string2 = this.readXMLDeclarationStatement(attr.getValue(), string);
                if (!this.validDeclaration(string2, "encoding", new String[]{"UTF-8", "UTF-16"})) {
                    node2 = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_NAMESPACE);
                    this.errors.add(node2 != null ? node2.getValue() : "");
                }
                if (!this.validDeclaration(string2, "version", new String[]{"1.0"})) {
                    this.errors.add("Version number in XML declaration is not 1.0.  XML schema file: " + attr.getValue());
                }
                if (XMLUtils.equals((node2 = this.validator.parseXMLDocumentURL(attr.getValue(), string)).getDocumentElement(), XMLTags.ELEM_XSD_SCHEMA)) {
                    Attr attr2 = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_NAMESPACE);
                    String string3 = attr2 != null ? attr2.getValue() : "";
                    this.processSchema(node2.getDocumentElement(), XMLUtils.createURLString(attr.getValue(), string));
                }
                this.result = "passed";
                this.result = "passed";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readXMLDeclarationStatement(String string, String string2) {
        Reader reader;
        String string3;
        block17: {
            string3 = null;
            try {
                new URL(string);
            }
            catch (Throwable throwable) {
                int n = string2.lastIndexOf(47);
                int n2 = string2.lastIndexOf(92);
                if (n2 > n) {
                    n = n2;
                }
                string = string2.substring(0, n + 1) + string;
            }
            if (string == null) return string3;
            URL uRL = null;
            reader = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            reader = uRL != null ? new InputStreamReader(uRL.openStream()) : new InputStreamReader(new FileInputStream(string));
            boolean bl = false;
            if (!reader.ready()) break block17;
            int n = reader.read();
            while (reader.ready() && n != 60) {
                n = reader.read();
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (n == 60) {
                stringBuffer.append((char)n);
                while (reader.ready() && !bl) {
                    n = reader.read();
                    stringBuffer.append((char)n);
                    bl = n == 62;
                }
            } else {
                string3 = "failed";
                this.failureDetailMessage = "Cannot read the XML declaration statement.";
            }
            string3 = stringBuffer.toString();
        }
        Object var10_14 = null;
        if (reader == null) return string3;
        try {
            reader.close();
            return string3;
        }
        catch (Throwable throwable) {}
        return string3;
        {
            catch (Exception exception) {
                this.errors.add(exception.getMessage());
                Object var10_15 = null;
                if (reader == null) return string3;
                try {
                    reader.close();
                    return string3;
                }
                catch (Throwable throwable) {}
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean validEncoding(String string) {
        boolean bl = true;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.OMMITED_XML_DECLARATION_DELIMITERS, this.XML_DECLARATION_DELIMITERS);
            Enumeration enumeration = stringTokenizer.parse(string);
            boolean bl2 = false;
            while (enumeration.hasMoreElements() && !bl2) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.equals("encoding")) continue;
                bl2 = true;
                enumeration.nextElement();
                String string3 = (String)enumeration.nextElement();
                bl = "UTF-8".equalsIgnoreCase(string3) || "UTF-16".equalsIgnoreCase(string3);
            }
        }
        return bl;
    }

    private boolean validDeclaration(String string, String string2, String[] stringArray) {
        boolean bl = true;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.OMMITED_XML_DECLARATION_DELIMITERS, this.XML_DECLARATION_DELIMITERS);
            Enumeration enumeration = stringTokenizer.parse(string);
            if (enumeration.hasMoreElements()) {
                boolean bl2 = false;
                while (enumeration.hasMoreElements() && !bl2) {
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.equals(string2)) continue;
                    bl2 = true;
                    bl = false;
                    enumeration.nextElement();
                    String string4 = (String)enumeration.nextElement();
                    for (int i = 0; i < stringArray.length && !bl; ++i) {
                        if (!stringArray[i].equalsIgnoreCase(string4)) continue;
                        bl = true;
                    }
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private void processSchema(Node node, String string) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (1 != node2.getNodeType() || !XMLUtils.equals(node2, XMLTags.ELEM_XSD_IMPORT)) continue;
            this.importFound = true;
            this.loadSchema(node2, string);
        }
    }
}

