/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLTags;
import org.wsi.xml.XMLUtils;

public class BP2102
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean importFound = false;

    public BP2102(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        try {
            Types types = (Types)entryContext.getEntry().getEntryDetail();
            List list = types.getExtensibilityElements();
            Definition definition = null;
            definition = this.validator.analyzerContext.getCandidateInfo().getDefinition(types);
            if (definition == null) {
                throw new WSIException("Could not find types definition in any WSDL document.");
            }
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                    if (extensibilityElement instanceof UnknownExtensibilityElement && extensibilityElement.getElementType().equals(XMLTags.ELEM_XSD_SCHEMA)) {
                        this.testNode(((UnknownExtensibilityElement)extensibilityElement).getElement(), definition.getDocumentBaseURI());
                    }
                    if (!this.result.equals("failed")) continue;
                    this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
                }
            }
            if (!this.importFound) {
                this.result = "notApplicable";
            }
        }
        catch (Throwable throwable) {
            this.result = "notApplicable";
            this.failureDetail = this.validator.createFailureDetail("WSDL document can not be processed", entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void testNode(Node node, String string) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                block9: {
                    if (XMLUtils.equals(node, XMLTags.ELEM_XSD_IMPORT)) {
                        Object object;
                        this.importFound = true;
                        Element element = (Element)node;
                        Attr attr = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_SCHEMALOCATION);
                        Attr attr2 = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_NAMESPACE);
                        if (attr == null && attr2 != null) {
                            object = this.validator.wsdlDocument.getSchemas();
                            if (object.keySet().contains(attr2.getValue())) {
                                node = node.getNextSibling();
                                continue;
                            }
                            attr = attr2;
                        }
                        if (attr != null && attr.getValue() != null) {
                            try {
                                object = this.validator.parseXMLDocumentURL(attr.getValue(), string);
                                if (!XMLUtils.equals(object.getDocumentElement(), XMLTags.ELEM_XSD_SCHEMA)) {
                                    throw new Exception();
                                }
                                this.testNode(object.getDocumentElement().getFirstChild(), XMLUtils.createURLString(attr.getValue(), string));
                                break block9;
                            }
                            catch (Throwable throwable) {
                                this.result = "failed";
                                this.failureDetailMessage = attr.getValue();
                                break;
                            }
                        }
                        this.result = "notApplicable";
                        this.failureDetailMessage = "schemaLocation == null and namespace == null";
                        break;
                    }
                }
                this.testNode(node.getFirstChild(), string);
            }
            node = node.getNextSibling();
        }
    }
}

