/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPFault;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class BP2022
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2022(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        SOAPFault[] sOAPFaultArray = this.validator.getSoapFaults(binding);
        if (sOAPFaultArray == null || sOAPFaultArray.length == 0) {
            this.result = "notApplicable";
        } else {
            for (int i = 0; i < sOAPFaultArray.length; ++i) {
                SOAPFault sOAPFault = sOAPFaultArray[i];
                if (sOAPFault.getName() != null) continue;
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("soapbind:fault element : " + sOAPFault.toString(), entryContext);
                break;
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

