/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class AP2909
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean multipleContentFound;

    public AP2909(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.multipleContentFound = false;
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List list = binding.getBindingOperations();
            for (int i = 0; i < list.size(); ++i) {
                BindingOperation bindingOperation = (BindingOperation)list.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List list2 = this.getMimeParts(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List list3 = this.getMimeParts(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (this.containsInvalidMimePart(list2)) {
                    throw new AssertionFailException("The invalid mime:part element is in the wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation.");
                }
                if (!this.containsInvalidMimePart(list3)) continue;
                throw new AssertionFailException("The invalid mime:part element is in the wsdl:output of the \"" + bindingOperation.getName() + "\" binding operation.");
            }
            if (!this.multipleContentFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsInvalidMimePart(List list) {
        for (int i = 0; i < list.size(); ++i) {
            boolean bl = false;
            String string = null;
            List list2 = ((MIMEPart)list.get(i)).getExtensibilityElements();
            for (int j = 0; j < list2.size(); ++j) {
                if (!((ExtensibilityElement)list2.get(j)).getElementType().equals(WSITag.WSDL_MIME_CONTENT)) continue;
                MIMEContent mIMEContent = (MIMEContent)list2.get(j);
                if (bl) {
                    this.multipleContentFound = true;
                    if (mIMEContent.getPart() != null && mIMEContent.getPart().equals(string)) continue;
                    return true;
                }
                bl = true;
                string = mIMEContent.getPart();
            }
        }
        return false;
    }

    private List getMimeParts(List list) {
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (!extensibilityElement.getElementType().equals(WSITag.WSDL_MIME_MULTIPART)) continue;
                List list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                arrayList.addAll(list2);
                for (int j = 0; j < list2.size(); ++j) {
                    List list3 = this.getMimeParts(((MIMEPart)list2.get(j)).getExtensibilityElements());
                    arrayList.addAll(list3);
                }
            }
        }
        return arrayList;
    }
}

