/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class AP2906
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2906(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean bl = false;
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List list = binding.getBindingOperations();
            for (int i = 0; i < list.size(); ++i) {
                BindingOperation bindingOperation = (BindingOperation)list.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List list2 = this.getMimeMultipartElements(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List list3 = this.getMimeMultipartElements(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (!list2.isEmpty()) {
                    bl = true;
                    if (this.containsInvalidMimePart(list2)) {
                        throw new AssertionFailException("The invalid mime:part element is in the wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                }
                if (list3.isEmpty()) continue;
                bl = true;
                if (!this.containsInvalidMimePart(list3)) continue;
                throw new AssertionFailException("The invalid mime:part element is in the wsdl:output of the \"" + bindingOperation.getName() + "\" binding operation.");
            }
            if (!bl) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsInvalidMimePart(List list) {
        for (int i = 0; i < list.size(); ++i) {
            List list2 = ((MIMEMultipartRelated)list.get(i)).getMIMEParts();
            if (list2.size() <= 1) continue;
            for (int j = 1; j < list2.size(); ++j) {
                List list3 = ((MIMEPart)list2.get(j)).getExtensibilityElements();
                for (int k = 0; k < list3.size(); ++k) {
                    if (!((ExtensibilityElement)list3.get(k)).getElementType().equals(WSITag.WSDL_SOAP_HEADER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List getMimeMultipartElements(List list) {
        ArrayList<ExtensibilityElement> arrayList = new ArrayList<ExtensibilityElement>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (!extensibilityElement.getElementType().equals(WSITag.WSDL_MIME_MULTIPART)) continue;
                arrayList.add(extensibilityElement);
                List list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                for (int j = 0; j < list2.size(); ++j) {
                    List list3 = this.getMimeMultipartElements(((MIMEPart)list2.get(j)).getExtensibilityElements());
                    arrayList.addAll(list3);
                }
            }
        }
        return arrayList;
    }
}

