/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class AP2901
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private Collection mimeElements;

    public AP2901(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
        this.mimeElements = new HashSet();
        this.mimeElements.add(WSITag.WSDL_MIME_CONTENT);
        this.mimeElements.add(WSITag.WSDL_MIME_XML);
        this.mimeElements.add(WSITag.WSDL_MIME_MULTIPART);
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List list = binding.getBindingOperations();
            for (int i = 0; i < list.size(); ++i) {
                BindingOperation bindingOperation = (BindingOperation)list.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                QName qName = null;
                if (bindingInput != null && (qName = this.getInapplicableElement(bindingInput.getExtensibilityElements())) != null) {
                    throw new AssertionFailException(qName.toString());
                }
                if (bindingOutput == null || (qName = this.getInapplicableElement(bindingOutput.getExtensibilityElements())) == null) continue;
                throw new AssertionFailException(qName.toString());
            }
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private QName getInapplicableElement(List list) {
        for (int i = 0; i < list.size(); ++i) {
            QName qName = ((ExtensibilityElement)list.get(i)).getElementType();
            if (this.mimeElements.contains(qName) || qName.equals(WSITag.WSDL_SOAP_BODY) || qName.equals(WSITag.WSDL_SOAP_HEADER)) continue;
            return qName;
        }
        return null;
    }
}

