/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.uddi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.UDDIUtils;
import org.wsi.wsdl.WSDLDocument;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLUtils;

public class WSI3004
extends AssertionProcessVisitor
implements WSITag {
    private final UDDIValidatorImpl validator;
    private static final String PORTS_PARAM = "ports";
    private static final String BINDING_PARAM = "binding";

    public WSI3004(UDDIValidatorImpl uDDIValidatorImpl) {
        super(uDDIValidatorImpl);
        this.validator = uDDIValidatorImpl;
    }

    private HashSet getConformanceClaimsFromUDDI(TModel tModel) throws WSIException {
        String string = UDDIUtils.getWSIConformanceTModelKey(this.validator.uddiProxy);
        HashSet<String> hashSet = new HashSet<String>();
        CategoryBag categoryBag = tModel.getCategoryBag();
        if (categoryBag != null) {
            Vector vector = categoryBag.getKeyedReferenceVector();
            for (int i = 0; i < vector.size(); ++i) {
                KeyedReference keyedReference = (KeyedReference)vector.get(i);
                if (!keyedReference.getTModelKey().equalsIgnoreCase(string)) continue;
                hashSet.add(keyedReference.getKeyValue());
            }
        }
        return hashSet;
    }

    private HashSet getConformanceClaimsFromWSDL(TModel tModel) {
        HashSet hashSet = new HashSet();
        try {
            String string = this.validator.getOverviewURL(tModel);
            WSDLDocument wSDLDocument = this.validator.getWSDLDocument(string);
            Binding binding = this.validator.getBinding(string, wSDLDocument);
            String string2 = binding.getQName().getLocalPart();
            hashSet = this.getClaimsFromElement(binding.getDocumentationElement(), hashSet);
            Vector vector = this.getPorts(wSDLDocument, string2);
            for (int i = 0; i < vector.size(); ++i) {
                Port port = (Port)vector.get(i);
                hashSet = this.getClaimsFromElement(port.getDocumentationElement(), hashSet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet;
    }

    private HashSet getClaimsFromElement(Element element, HashSet hashSet) {
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        if (element != null) {
            Element element2 = XMLUtils.findChildElement(element, WSITag.WSI_CLAIM);
            while (element2 != null) {
                String string = element2.getAttribute(WSITag.ATTR_CLAIM_CONFORMSTO.getLocalPart());
                if (string != null) {
                    hashSet.add(string);
                }
                element2 = XMLUtils.findElement(element2, WSITag.WSI_CLAIM);
            }
        }
        return hashSet;
    }

    private Vector getPorts(WSDLDocument wSDLDocument, String string) {
        Vector vector = new Vector();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PORTS_PARAM, vector);
        hashMap.put(BINDING_PARAM, string);
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitPort(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.ignoreImport();
        wSDLTraversal.traverse(wSDLDocument.getDefinitions(), hashMap);
        return vector;
    }

    public void visit(Port port, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (port.getBinding().getQName().getLocalPart().equals(wSDLTraversalContext.getParameter(BINDING_PARAM).toString())) {
            ((Vector)wSDLTraversalContext.getParameter(PORTS_PARAM)).add(port);
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel.";
        } else {
            try {
                HashSet hashSet = this.getConformanceClaimsFromUDDI(tModel);
                HashSet hashSet2 = this.getConformanceClaimsFromWSDL(tModel);
                if (hashSet.size() == 0) {
                    this.result = "passed";
                } else if (hashSet.size() == hashSet2.size()) {
                    int n = 0;
                    Iterator iterator = hashSet2.iterator();
                    block2: while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        Iterator iterator2 = hashSet.iterator();
                        while (iterator2.hasNext()) {
                            String string2 = (String)iterator2.next();
                            if (!string.equalsIgnoreCase(string2)) continue;
                            ++n;
                            continue block2;
                        }
                    }
                    if (n != hashSet2.size()) {
                        this.result = "failed";
                        this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "].";
                    }
                } else {
                    this.result = "failed";
                    this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "].";
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.result = "failed";
                this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "].";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }
}

