/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionPassException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.util.HTTPUtils;
import org.wsi.xml.XMLUtils;

public class WSI1311
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1311(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        boolean bl = this.validator.isOneWayResponse(entryContext);
        Document document = null;
        if (!bl) {
            document = entryContext.getResponseDocument();
        }
        if (!bl && this.validator.isFault(document)) {
            this.result = "passed";
        } else {
            TypesRegistry typesRegistry;
            Binding binding;
            OperationSignature.OperationMatch operationMatch;
            Document document2 = entryContext.getRequestDocument();
            String string = entryContext.getRequest().getHTTPHeaders();
            String string2 = null;
            if (string != null) {
                string2 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get("SOAPAction");
            }
            if ((operationMatch = OperationSignature.matchOperation(document2, string2, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], typesRegistry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                this.result = "notApplicable";
            } else {
                try {
                    Object object;
                    BindingOperation bindingOperation = operationMatch.getOperation();
                    Operation operation = null;
                    List list = binding.getExtensibilityElements();
                    Object object2 = list.iterator();
                    while (object2.hasNext()) {
                        Object e = object2.next();
                        if (!(e instanceof SOAPBinding) || "http://schemas.xmlsoap.org/soap/http".equals((object = (SOAPBinding)e).getTransportURI())) continue;
                        throw new AssertionFailException();
                    }
                    operation = bindingOperation.getOperation();
                    if (operation == null) {
                        throw new AssertionFailException();
                    }
                    if (bl) {
                        if (operation.getOutput() == null) {
                            throw new AssertionPassException();
                        }
                        throw new AssertionFailException();
                    }
                    object2 = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                    if (object2 == null || object2.getLength() == 0) {
                        throw new AssertionFailException();
                    }
                    for (int i = 0; i < object2.getLength(); ++i) {
                        object = (Element)object2.item(i);
                        Element element = XMLUtils.getFirstChild((Element)object);
                        while (element != null) {
                            Message message = operation.getOutput().getMessage();
                            QName qName = new QName(element.getNamespaceURI(), element.getLocalName());
                            if (message != null && qName.equals(message.getQName())) {
                                throw new AssertionPassException();
                            }
                            element = XMLUtils.getNextSibling(element);
                        }
                    }
                }
                catch (AssertionPassException assertionPassException) {
                    this.result = "passed";
                }
                catch (AssertionFailException assertionFailException) {
                    this.result = "failed";
                }
            }
        }
        if (this.result == "failed") {
            this.failureDetail = this.validator.createFailureDetail(null, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

