/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.analyzer.AssertionPassException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class WSI1121
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1121(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean bl;
            BindingOperation[] bindingOperationArray;
            Binding[] bindingArray = this.validator.analyzerContext.getCandidateInfo().getBindings();
            Document document = null;
            QName qName = null;
            if (!entryContext.getMessageEntry().getMessage().equals("") && (bindingOperationArray = this.validator.getSoapBodyChild(document = XMLUtils.parseXML(entryContext.getMessageEntry().getMessage()))) != null) {
                qName = new QName(bindingOperationArray.getNamespaceURI(), bindingOperationArray.getLocalName());
            }
            if (document == null || this.validator.isFault(document)) {
                throw new AssertionNotApplicableException();
            }
            bindingOperationArray = this.validator.getMatchingBindingOps("document", bindingArray);
            BindingOperation[] bindingOperationArray2 = this.validator.getDocLitOperations(entryContext.getEntry().getEntryType(), qName, bindingOperationArray);
            if (bindingOperationArray2.length == 0) {
                throw new AssertionNotApplicableException();
            }
            try {
                bl = this.validator.messageIsDocLitSchemaValid(entryContext);
            }
            catch (Exception exception) {
                throw new AssertionFailException();
            }
            if (bl) {
                throw new AssertionPassException();
            }
            throw new AssertionFailException();
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

