/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class WSI1110
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1110(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document document;
        if (entryContext.getMessageEntry() != null && !this.validator.isOneWayResponse(entryContext) && (document = entryContext.getMessageEntryDocument()) != null) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagNameNS("http://ws-i.org/schemas/conformanceClaim/", "Claim");
            if (nodeList == null || nodeList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    Attr attr = element2.getAttributeNode("conformsTo");
                    if (attr != null) continue;
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                    break;
                }
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

