/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class WSI1109
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1109(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (entryContext.getMessageEntry() != null && !this.validator.isOneWayResponse(entryContext)) {
            try {
                NodeList nodeList;
                Document document = entryContext.getMessageEntryDocument();
                Element element = document.getDocumentElement();
                NodeList nodeList2 = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
                Element element2 = null;
                if (nodeList2 != null && nodeList2.getLength() != 0) {
                    element2 = (Element)nodeList2.item(0);
                }
                if ((nodeList = element.getElementsByTagNameNS("http://ws-i.org/schemas/conformanceClaim/", "Claim")) == null || nodeList.getLength() == 0) {
                    this.result = "notApplicable";
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (element2 != null && nodeList.item(i).getParentNode() == element2) continue;
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                }
            }
            catch (Exception exception) {
                this.result = "notApplicable";
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

