/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.HTTPUtils;

public class BP4103
extends AssertionProcess {
    private static final String HTTP_AUTH_SCHEME_BASIC = "Basic";
    private static final String HTTP_AUTH_SCHEME_DIGEST = "Digest";
    private final BaseMessageValidator validator;

    public BP4103(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String string = entryContext.getMessageEntry().getHTTPHeaders();
        if (entryContext.getMessageEntry().getType().equals("request")) {
            if (!this.containsInvalidAuth(string, "Authorization") && !this.containsInvalidAuth(string, "Proxy-Authorization")) {
                this.result = "notApplicable";
            }
        } else if (!this.containsInvalidAuth(string, "WWW-Authenticate") && !this.containsInvalidAuth(string, "Proxy-Authenticate")) {
            this.result = "notApplicable";
        }
        if (this.result.equals("passed")) {
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsInvalidAuth(String string, String string2) {
        String string3 = null;
        try {
            string3 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            int n = string3.indexOf(" ");
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            if (!string3.equalsIgnoreCase(HTTP_AUTH_SCHEME_BASIC) && !string3.equalsIgnoreCase(HTTP_AUTH_SCHEME_DIGEST)) {
                return true;
            }
        }
        return false;
    }
}

