/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.MIMEUtils;
import org.wsi.xml.XMLUtils;

public class AP1942
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public AP1942(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Message message;
            List list;
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            if (mimeParts.count() < 2) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            if ("request".equals(entryContext.getEntry().getEntryType())) {
                list = bindingOperation.getBindingInput() == null ? null : bindingOperation.getBindingInput().getExtensibilityElements();
                message = bindingOperation.getOperation().getInput() == null ? null : bindingOperation.getOperation().getInput().getMessage();
            } else {
                list = bindingOperation.getBindingOutput() == null ? null : bindingOperation.getBindingOutput().getExtensibilityElements();
                message = bindingOperation.getOperation().getOutput() == null ? null : bindingOperation.getOperation().getOutput().getMessage();
            }
            boolean bl = false;
            Iterator iterator = mimeParts.getParts().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                QName qName;
                Part part;
                String string;
                MimePart mimePart;
                block15: {
                    ++n;
                    mimePart = (MimePart)iterator.next();
                    string = MIMEUtils.getMimeHeaderAttribute(mimePart.getHeaders(), "Content-ID");
                    try {
                        int n2 = string.indexOf("=");
                        if (n2 == -1 || !string.startsWith("<")) break block15;
                        string = this.encodePartName(string.substring(1, n2));
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!this.boundToMimeContent(list, string) || message == null || (part = (Part)message.getParts().get(string)) == null || (qName = part.getElementName()) == null) continue;
                bl = true;
                Document document = null;
                try {
                    document = XMLUtils.parseXML(mimePart.getContent());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (document == null) {
                    throw new AssertionFailException("The bound message part of the MIME part number " + (n + 1) + " is invalid XML infoset.");
                }
                QName qName2 = new QName(document.getDocumentElement().getNamespaceURI(), document.getDocumentElement().getLocalName());
                if (qName.equals(qName2)) continue;
                throw new AssertionFailException("The root element name is " + qName2 + ", the name of the referenced element is " + qName + ".");
            }
            if (!bl) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean boundToMimeContent(List list, String string) {
        ExtensibilityElement extensibilityElement;
        if (list != null && list.size() > 0 && (extensibilityElement = (ExtensibilityElement)list.get(0)).getElementType().equals(WSITag.WSDL_MIME_MULTIPART)) {
            List list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
            for (int i = 0; i < list2.size(); ++i) {
                ExtensibilityElement extensibilityElement2;
                List list3 = ((MIMEPart)list2.get(i)).getExtensibilityElements();
                if (list3.size() <= 0 || !(extensibilityElement2 = (ExtensibilityElement)list3.get(0)).getElementType().equals(WSITag.WSDL_MIME_CONTENT) || !string.equals(((MIMEContent)extensibilityElement2).getPart())) continue;
                return true;
            }
        }
        return false;
    }

    private String encodePartName(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%' && string.length() > i + 2) {
                try {
                    int n = Integer.parseInt(String.valueOf(string.charAt(i + 1)) + String.valueOf(string.charAt(i + 2)), 16);
                    stringBuffer.append((char)n);
                    i += 2;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }
}

