/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.MIMEUtils;

public class AP1933
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1933(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List list = null;
            if (entryContext.getMessageEntry().getType().equals("request") && bindingOperation.getBindingInput() != null) {
                list = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && bindingOperation.getBindingOutput() != null) {
                list = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (list == null || list.size() == 0 || !(list.get(0) instanceof MIMEMultipartRelated)) {
                throw new AssertionNotApplicableException();
            }
            MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)list.get(0);
            List list2 = mIMEMultipartRelated.getMIMEParts();
            for (int i = 1; i < list2.size(); ++i) {
                String string = this.getMIMEContentPart((MIMEPart)list2.get(i));
                if (this.findMIMEPart(mimeParts.getParts(), string) != null) continue;
                throw new AssertionFailException("The corresponding binding operation \"" + bindingOperation.getName() + "\" does not contain part \"" + string + "\"");
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String findMIMEPart(Collection collection, String string) throws WSIException, AssertionFailException {
        if (string == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            ++n;
            MimePart mimePart = (MimePart)iterator.next();
            String string2 = MIMEUtils.getMimeHeaderAttribute(mimePart.getHeaders(), "Content-ID");
            if (string2 == null || !string2.startsWith("<") || !string2.endsWith(">")) continue;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n3 = string2.indexOf("=");
            if (n3 != -1) {
                string3 = this.encodePartName(string2.substring(1, n3));
            }
            if ((n2 = string2.indexOf("@")) != -1 && n2 > n3) {
                string4 = string2.substring(n3 + 1, n2);
                string5 = string2.substring(n2 + 1, string2.length() - 1);
            }
            if (string3 == null || !string3.equals(string)) continue;
            if (string4 == null || string4.length() == 0) {
                throw new AssertionFailException("The \"Content-ID\" attribute of the part \"" + (n + 1) + "\"contains value \"" + string2 + "\" which has a incorrect UID format");
            }
            if (string5 == null) {
                throw new AssertionFailException("The \"Content-ID\" attribute of the part \"" + (n + 1) + "\"contains value \"" + string2 + "\" which has a incorrect host format");
            }
            try {
                new URL("HTTP", string5, "");
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionFailException("The \"Content-ID\" attribute of the part \"" + (n + 1) + "\"contains value \"" + string2 + "\" which has a incorrect host format");
            }
            return string2;
        }
        return null;
    }

    private String getMIMEContentPart(MIMEPart mIMEPart) {
        List list = mIMEPart.getExtensibilityElements();
        if (list.size() == 0) {
            return null;
        }
        return ((MIMEContent)list.get(0)).getPart();
    }

    private String encodePartName(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%' && string.length() > i + 2) {
                try {
                    int n = Integer.parseInt(String.valueOf(string.charAt(i + 1)) + String.valueOf(string.charAt(i + 2)), 16);
                    stringBuffer.append((char)n);
                    i += 2;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }
}

