/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class AP1931
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1931(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (entryContext.getMessageEntry().isMimeContent() && entryContext.getMessageEntry().getMimeParts().getRootPart() != null) {
            try {
                Document document = XMLUtils.parseXML(entryContext.getMessageEntry().getMimeParts().getRootPart().getContent());
                Element element = document.getDocumentElement();
                if (!element.getLocalName().equals(WSITag.ELEM_SOAP_ENVELOPE.getLocalPart()) || !element.getNamespaceURI().equals(WSITag.ELEM_SOAP_ENVELOPE.getNamespaceURI())) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("the entity body of the root part is {" + element.getNamespaceURI() + "}" + element.getLocalName(), entryContext);
                }
            }
            catch (Exception exception) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("the entity body of the root part does not contain \"soap:Envelope\" element", entryContext);
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

