/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.HTTPUtils;

public class AP1925
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1925(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List list = null;
            if (entryContext.getMessageEntry().getType().equals("request") && bindingOperation.getBindingInput() != null) {
                list = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && bindingOperation.getBindingOutput() != null) {
                list = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (list == null || list.size() == 0 || !(list.get(0) instanceof MIMEMultipartRelated)) {
                throw new AssertionNotApplicableException();
            }
            MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)list.get(0);
            List list2 = mIMEMultipartRelated.getMIMEParts();
            if (list2.size() <= 1) {
                throw new AssertionNotApplicableException();
            }
            String string = HTTPUtils.getHttpHeaderAttribute(entryContext.getMessageEntry().getHTTPHeaders(), "Content-Type");
            if (string == null || !string.equalsIgnoreCase("multipart/related")) {
                throw new AssertionFailException("Incorrect Content-Type value \"" + string + "\" in HTTP header");
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private String getMIMEContentPart(MIMEPart mIMEPart) {
        List list = mIMEPart.getExtensibilityElements();
        if (list.size() == 0) {
            return null;
        }
        return ((MIMEContent)list.get(0)).getPart();
    }
}

