/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.soap.SOAPBody;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.util.HTTPUtils;

public class AP1917
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1917(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (entryContext.getMessageEntry().isMimeContent() && entryContext.getMessageEntry().getMimeParts().count() > 1) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), entryContext.getMessageEntryDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List list = null;
            if (entryContext.getMessageEntry().getType().equals("request") && bindingOperation.getBindingInput() != null) {
                list = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && bindingOperation.getBindingOutput() != null) {
                list = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (list == null || list.size() == 0) {
                throw new AssertionNotApplicableException();
            }
            boolean bl = false;
            if (list.get(0) instanceof MIMEMultipartRelated) {
                if (((MIMEMultipartRelated)list.get(0)).getMIMEParts().size() != 1) {
                    throw new AssertionNotApplicableException();
                }
                bl = true;
            } else if (!(list.get(0) instanceof SOAPBody)) {
                throw new AssertionNotApplicableException();
            }
            String string = HTTPUtils.getHttpHeaderAttribute(entryContext.getMessageEntry().getHTTPHeaders(), "Content-Type");
            if (string == null || !string.equalsIgnoreCase("multipart/related") && !string.equalsIgnoreCase("text/xml") || string.equalsIgnoreCase("multipart/related") && !bl) {
                throw new AssertionFailException("The content-type header field  value \"" + string + "\" is incorrect");
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

