/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1308
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public BP1308(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document document = entryContext.getMessageEntryDocument();
            if (document == null) {
                throw new AssertionNotApplicableException();
            }
            NodeList nodeList = document.getElementsByTagNameNS(WSITag.ELEM_SOAP_BODY.getNamespaceURI(), WSITag.ELEM_SOAP_BODY.getLocalPart());
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            Element element = XMLUtils.getFirstChild((Element)nodeList.item(0));
            while (element != null) {
                if (element.getAttributeNodeNS(WSITag.ELEM_SOAP_BODY.getNamespaceURI(), "encodingStyle") != null) {
                    throw new AssertionFailException("The child element name is \"" + element.getNodeName() + "\".");
                }
                element = XMLUtils.getNextSibling(element);
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

