/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1213
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1213(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document document = entryContext.getMessageEntryDocument();
            Element element = null;
            if (document == null || this.validator.isFault(document) || (element = this.validator.getSoapBodyChild(document)) == null) {
                throw new AssertionNotApplicableException();
            }
            QName qName = new QName(element.getNamespaceURI(), element.getLocalName());
            BindingOperation[] bindingOperationArray = this.validator.getMatchingBindingOps("document", this.validator.analyzerContext.getCandidateInfo().getBindings());
            BindingOperation[] bindingOperationArray2 = this.validator.getDocLitOperations(entryContext.getEntry().getEntryType(), qName, bindingOperationArray);
            if (bindingOperationArray2.length != 1) {
                throw new AssertionNotApplicableException();
            }
            List list = null;
            if (entryContext.getMessageEntry().getType().equals("request") && bindingOperationArray2[0].getBindingInput() != null) {
                list = bindingOperationArray2[0].getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && bindingOperationArray2[0].getBindingOutput() != null) {
                list = bindingOperationArray2[0].getBindingOutput().getExtensibilityElements();
            }
            List list2 = null;
            SOAPBody sOAPBody = this.validator.getSOAPBody(list);
            if (sOAPBody != null) {
                list2 = sOAPBody.getParts();
            }
            if (list2 != null && list2.isEmpty() && !XMLUtils.getChildElements(element).isEmpty()) {
                throw new AssertionFailException("wsdl:operation name is " + bindingOperationArray2[0].getName());
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

