/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class BP1203
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1203(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document document;
        boolean bl = false;
        if (this.validator.isOneWayResponse(entryContext) || (document = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else if (entryContext.getMessageEntry().getType().equalsIgnoreCase("response")) {
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            if (nodeList == null || nodeList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                try {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element = (Element)nodeList.item(i);
                        NodeList nodeList2 = element.getElementsByTagName("detail");
                        if (nodeList2 == null) continue;
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            NamedNodeMap namedNodeMap = nodeList2.item(j).getAttributes();
                            if (namedNodeMap == null) continue;
                            for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                                Attr attr = (Attr)namedNodeMap.item(k);
                                if (attr.getNamespaceURI() == null) continue;
                                bl = true;
                                if (!attr.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) continue;
                                throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                            }
                        }
                    }
                    if (!bl) {
                        this.result = "notApplicable";
                    }
                }
                catch (AssertionFailException assertionFailException) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
                }
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

