/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class BP1201
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public BP1201(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document document;
        if (this.validator.isOneWayResponse(entryContext) || (document = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            Element element = document.getDocumentElement();
            String string = element.getNamespaceURI();
            String string2 = element.getLocalName();
            if (!WSITag.ELEM_SOAP_ENVELOPE.getNamespaceURI().equals(string)) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("Root element has namespace: " + string, entryContext);
            } else if (!WSITag.ELEM_SOAP_ENVELOPE.getLocalPart().equals(string2)) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("Root element has local name: " + string2, entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

