/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.NullUtil;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.test.util.WSDLUtil;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLUtils;

public class BP1107
extends AssertionProcessVisitor {
    private final BaseMessageValidator validator;
    private OperationSignature responseSig = null;
    private Vector faults = null;

    public BP1107(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public void visit(SOAPFault sOAPFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Operation operation;
        String string = sOAPFault.getName();
        if (string == null) {
            string = wSDLTraversalContext.getBindingFault().getName();
        }
        if ((operation = wSDLTraversalContext.getBindingOperation().getOperation()) == null) {
            return;
        }
        Fault fault = operation.getFault(string);
        if (fault == null) {
            return;
        }
        Message message = fault.getMessage();
        if (message == null || message.getParts() == null || message.getParts().size() != 1) {
            return;
        }
        Part part = (Part)message.getParts().values().iterator().next();
        TypesRegistry typesRegistry = (TypesRegistry)wSDLTraversalContext.getParameter("TypesRegistry");
        QName qName = part.getElementName();
        QName qName2 = part.getTypeName();
        if (qName2 == null) {
            qName2 = typesRegistry.getType(part.getElementName());
        }
        if (qName2 == null) {
            throw new IllegalArgumentException("Part type can not be null.");
        }
        int n = 0;
        while (n < this.faults.size()) {
            boolean bl;
            Element element = (Element)this.faults.get(n);
            boolean bl2 = bl = qName != null && element.getLocalName().equals(qName.getLocalPart()) && NullUtil.equals(element.getNamespaceURI(), qName.getNamespaceURI());
            if (bl) {
                this.faults.remove(n);
                continue;
            }
            ++n;
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            Document document = entryContext.getRequestDocument();
            Document document2 = entryContext.getMessageEntryDocument();
            if (document == null || document2 == null) {
                this.result = "notApplicable";
            } else if (!this.validator.isFault(document2)) {
                this.result = "notApplicable";
            } else {
                OperationSignature.OperationMatch operationMatch = OperationSignature.matchOperation(document, this.validator.getSoapAction(entryContext.getRequest().getHTTPHeaders()), this.validator.analyzerContext.getCandidateInfo().getBindings()[0], new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator));
                this.result = "notApplicable";
                if (operationMatch != null) {
                    this.responseSig = new OperationSignature(document2);
                    if ("rpc".equals(operationMatch.getOperationStyle())) {
                        this.responseSig.createRPCSignature();
                    }
                    WSDLTraversal wSDLTraversal = new WSDLTraversal();
                    wSDLTraversal.setVisitor(this);
                    wSDLTraversal.visitSOAPFault(true);
                    wSDLTraversal.ignoreBindingInput();
                    wSDLTraversal.ignoreBindingOutput();
                    if (this.responseSig == null || !this.responseSig.isFault()) {
                        this.result = "notApplicable";
                    } else if (this.responseSig != null && this.responseSig.isFault()) {
                        Element element = XMLUtils.findChildElement(document2.getDocumentElement(), WSITag.ELEM_SOAP_BODY);
                        Element element2 = XMLUtils.findChildElement(element, WSITag.ELEM_SOAP_FAULT);
                        Element element3 = XMLUtils.getElement("detail", element2);
                        if (element3 == null) {
                            this.result = "notApplicable";
                        } else {
                            this.result = "passed";
                            this.faults = XMLUtils.getChildElements(element3);
                            if (this.faults.size() > 0) {
                                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                WSDLUtil.expandDefinition(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions());
                                hashMap.put("definition", this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions());
                                TypesRegistry typesRegistry = new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator);
                                hashMap.put("TypesRegistry", typesRegistry);
                                wSDLTraversal.traverse(operationMatch.getOperation(), hashMap);
                                if (this.faults.size() > 0) {
                                    this.result = "warning";
                                    StringWriter stringWriter = new StringWriter();
                                    for (int i = 0; i < this.faults.size(); ++i) {
                                        try {
                                            XMLUtils.serializeElement((Element)this.faults.get(i), stringWriter);
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    try {
                                        stringWriter.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    this.failureDetail = this.validator.createFailureDetail("\nFaults:\n" + stringWriter.toString(), entryContext);
                                } else {
                                    this.result = "passed";
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

