/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.analyzer.AssertionPassException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.util.HTTPUtils;
import org.wsi.xml.XMLUtils;

public class BP1009
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1009(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry typesRegistry;
            Binding binding;
            OperationSignature.OperationMatch operationMatch;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document document = entryContext.getMessageEntryDocument();
            Document document2 = entryContext.getRequestDocument();
            if (document == null || document2 == null) {
                throw new AssertionNotApplicableException();
            }
            if (!this.validator.containsSoapBodyWithChild(document)) {
                throw new AssertionNotApplicableException();
            }
            if (this.validator.isFault(document)) {
                throw new AssertionFailException("notApplicable");
            }
            String string = entryContext.getRequest().getHTTPHeaders();
            String string2 = null;
            if (string != null) {
                string2 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get("SOAPAction");
            }
            if ((operationMatch = OperationSignature.matchOperation(document2, string2, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], typesRegistry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = operationMatch.getOperation();
            if (bindingOperation.getOperation().getStyle().equals(OperationType.ONE_WAY) && entryContext.getMessageEntry().getType().equals("response")) {
                throw new AssertionNotApplicableException();
            }
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (nodeList.getLength() == 0 || nodeList.getLength() > 1) {
                throw new AssertionPassException();
            }
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = document.getElementsByTagNameNS(WSITag.ELEM_SOAP_HEADER.getNamespaceURI(), WSITag.ELEM_SOAP_HEADER.getLocalPart());
            List list = null;
            if (entryContext.getMessageEntry().getType().equals("request")) {
                if (bindingOperation.getBindingInput() == null) throw new AssertionFailException();
                list = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response")) {
                if (bindingOperation.getBindingOutput() == null) throw new AssertionFailException();
                list = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (list == null || list.size() == 0) {
                throw new AssertionPassException();
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SOAPHeader) || this.isBindingHeaderInSOAPMessage(entryContext, nodeList2, (SOAPHeader)e)) continue;
                throw new AssertionFailException();
            }
            this.result = "passed";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = assertionFailException.getMessage() != null && assertionFailException.getMessage().length() > 0 ? assertionFailException.getMessage() : "failed";
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        if (this.result != "failed") return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
        this.failureDetail = this.validator.createFailureDetail(null, entryContext);
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean isBindingHeaderInSOAPMessage(EntryContext entryContext, NodeList nodeList, SOAPHeader sOAPHeader) {
        Message message = this.getMessageByQName(entryContext, sOAPHeader.getMessage());
        if (message == null) {
            return false;
        }
        Part part = message.getPart(sOAPHeader.getPart());
        if (part == null) {
            return false;
        }
        QName qName = part.getElementName();
        QName qName2 = part.getTypeName();
        if (qName2 == null && qName == null) {
            return false;
        }
        if (nodeList == null || nodeList.getLength() == 0) {
            return false;
        }
        Vector vector = XMLUtils.getChildElements((Element)nodeList.item(0));
        for (int i = 0; i < vector.size(); ++i) {
            Element element = (Element)vector.get(i);
            if (element == null) continue;
            QName qName3 = new QName(element.getNamespaceURI(), element.getLocalName());
            if ((qName2 == null || !qName2.equals(qName3)) && (qName == null || !qName.equals(qName3))) continue;
            return true;
        }
        return false;
    }

    private Message getMessageByQName(EntryContext entryContext, QName qName) {
        Definition[] definitionArray = this.validator.analyzerContext.getCandidateInfo().getDefinitions();
        for (int i = 0; i < definitionArray.length; ++i) {
            Message message = definitionArray[i].getMessage(qName);
            if (message == null) continue;
            return message;
        }
        return null;
    }
}

