/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.util.HTTPUtils;
import org.wsi.xml.XMLUtils;

public class BP1005
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1005(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry typesRegistry;
            Binding binding;
            OperationSignature.OperationMatch operationMatch;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document document = entryContext.getMessageEntryDocument();
            if (this.validator.isFault(document)) {
                throw new AssertionNotApplicableException();
            }
            if (!this.validator.containsSoapBodyWithChild(document)) {
                throw new AssertionNotApplicableException();
            }
            Document document2 = entryContext.getRequestDocument();
            String string = entryContext.getRequest().getHTTPHeaders();
            String string2 = null;
            if (string != null) {
                string2 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get("SOAPAction");
            }
            if ((operationMatch = OperationSignature.matchOperation(document2, string2, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], typesRegistry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = operationMatch.getOperation();
            if (!"rpc".equals(operationMatch.getOperationStyle())) {
                throw new AssertionNotApplicableException();
            }
            List list = null;
            if (bindingOperation.getBindingOutput() != null) {
                list = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (!this.validator.isLiteral(list)) {
                throw new AssertionNotApplicableException();
            }
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (nodeList.getLength() == 0 || nodeList.getLength() > 1) {
                throw new AssertionFailException();
            }
            Element element = (Element)nodeList.item(0);
            Element element2 = XMLUtils.getFirstChild(element);
            if (element2 == null) {
                throw new AssertionFailException();
            }
            this.result = element2.getLocalName().equals(bindingOperation.getName() + "Response") ? "passed" : "failed";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

