/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl;

import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.xerces.util.URI;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.analyzer.AnalyzerContext;
import org.wsi.test.analyzer.CandidateInfo;
import org.wsi.test.analyzer.ServiceReference;
import org.wsi.test.analyzer.config.AnalyzerConfig;
import org.wsi.test.log.Log;
import org.wsi.test.log.MessageEntry;
import org.wsi.test.profile.ProfileArtifact;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.BaseValidatorImpl;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.FailureDetail;
import org.wsi.test.report.ReportArtifact;
import org.wsi.test.report.Reporter;
import org.wsi.test.util.EntryType;
import org.wsi.wsdl.WSDLDocument;
import org.wsi.wsdl.WSDLUtils;
import org.wsi.xml.XMLTags;
import org.wsi.xml.XMLUtils;
import org.xml.sax.SAXException;

public abstract class BaseMessageValidator
extends BaseValidatorImpl {
    private WSDLDocument wsdlDocument;
    protected MessageEntry logEntry;
    protected Log log;

    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, WSDLDocument wSDLDocument, Reporter reporter) throws WSIException {
        super.init(analyzerContext, profileArtifact, reportArtifact, reporter);
        this.wsdlDocument = wSDLDocument;
    }

    public WSDLDocument getWSDLDocument() {
        return this.wsdlDocument;
    }

    public void validate(EntryContext entryContext) throws WSIException {
        this.logEntry = entryContext.getMessageEntry();
        AnalyzerConfig analyzerConfig = this.reporter.getReport().getReportContext().getAnalyzer().getAnalyzerConfig();
        if (this.wsdlDocument == null || this.messageCorrelatesToService(entryContext, analyzerConfig.getCorrelationType())) {
            String string = this.getClass().getPackage().getName() + ".";
            this.processAssertions(string, entryContext);
        }
    }

    private boolean messageCorrelatesToService(EntryContext entryContext, String string) throws WSIException {
        Object object;
        Object object2;
        URI[] uRIArray = null;
        boolean bl = false;
        CandidateInfo candidateInfo = this.analyzerContext.getCandidateInfo();
        ServiceReference serviceReference = this.analyzerContext.getServiceReference();
        Definition definition = candidateInfo.getWsdlDocument().getDefinitions();
        Binding binding = null;
        if (serviceReference.getWSDLElement().isPort()) {
            object2 = definition.getService(serviceReference.getWSDLElement().getParentElementQName());
            object = object2.getPort(serviceReference.getWSDLElement().getName());
            binding = object.getBinding();
        } else if (serviceReference.getWSDLElement().isBinding()) {
            binding = definition.getBinding(serviceReference.getWSDLElement().getQName());
        }
        if (binding == null) {
            return false;
        }
        uRIArray = this.hostAndPortCorrelation(entryContext);
        if (uRIArray != null && this.urlPathCorrelation(entryContext, uRIArray)) {
            if (string.equals("endpoint")) {
                bl = true;
            } else {
                object2 = this.getHttpRequestType(entryContext);
                if (object2 != null && ((String)object2).equalsIgnoreCase("GET")) {
                    bl = true;
                } else {
                    object = entryContext.getRequestDocument();
                    if (this.namespaceCorrelation(binding, (Document)object)) {
                        if (string.equals("namespace")) {
                            bl = true;
                        } else if (this.operationCorrelation(binding, (Document)object) && string.equals("operation")) {
                            bl = true;
                        } else {
                            throw new WSIException("Bad correlation type found in config: " + string);
                        }
                    }
                }
            }
        }
        return bl;
    }

    private URI[] hostAndPortCorrelation(EntryContext entryContext) throws WSIException {
        String string = entryContext.getRequest().getReceiverHostAndPort();
        return this.analyzerContext.getCandidateInfo().getEndPoints(string);
    }

    private boolean urlPathCorrelation(EntryContext entryContext, URI[] uRIArray) throws WSIException {
        Vector vector = this.getHttpRequest(entryContext.getRequest().getHTTPHeaders());
        if (vector == null) {
            return false;
        }
        String string = (String)vector.get(1);
        Vector<URI> vector2 = new Vector<URI>();
        for (int i = 0; i < uRIArray.length; ++i) {
            if (!uRIArray[i].toString().endsWith(string)) continue;
            vector2.add(uRIArray[i]);
        }
        return vector2.size() != 0;
    }

    private boolean namespaceCorrelation(Binding binding, Document document) throws WSIException {
        boolean bl = false;
        String string = "document";
        String string2 = this.getSoapBodyChild(document).getNamespaceURI();
        SOAPBinding sOAPBinding = null;
        sOAPBinding = WSDLUtils.getSoapBinding(binding);
        if (sOAPBinding != null) {
            string = sOAPBinding.getStyle();
        }
        Iterator iterator = binding.getBindingOperations().iterator();
        while (iterator.hasNext() && !bl) {
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            if (WSDLUtils.isRpcLiteral(string, bindingOperation)) {
                SOAPBody sOAPBody = WSDLUtils.getInputSoapBody(bindingOperation);
                if (sOAPBody.getNamespaceURI() == null || !sOAPBody.getNamespaceURI().equals(string2)) continue;
                bl = true;
                continue;
            }
            if (!WSDLUtils.isDocLiteral(string, bindingOperation)) continue;
            Iterator iterator2 = null;
            String string3 = this.getFirstPartName(bindingOperation);
            Map map = null;
            map = bindingOperation.getOperation().getInput().getMessage().getParts();
            if (map == null) continue;
            iterator2 = map.values().iterator();
            int n = string3 == null ? 1 : map.size();
            for (int i = 0; i < n && !bl; ++i) {
                Part part = (Part)iterator2.next();
                if (string3 != null && (string3 == null || !part.getName().equals(string3)) || part.getElementName().getNamespaceURI() == null || !part.getElementName().getNamespaceURI().equals(string2)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean operationCorrelation(Binding binding, Document document) throws WSIException {
        Element element;
        boolean bl = false;
        String string = "document";
        SOAPBinding sOAPBinding = null;
        sOAPBinding = WSDLUtils.getSoapBinding(binding);
        if (sOAPBinding != null) {
            string = sOAPBinding.getStyle();
        }
        if ((element = this.getSoapBodyChild(document)) != null) {
            String string2 = element.getLocalName();
            QName qName = new QName(element.getNamespaceURI(), string2);
            Iterator iterator = binding.getBindingOperations().iterator();
            while (iterator.hasNext() && !bl) {
                BindingOperation bindingOperation = (BindingOperation)iterator.next();
                if (WSDLUtils.isRpcLiteral(string, bindingOperation)) {
                    if (!bindingOperation.getName().equals(string2)) continue;
                    bl = true;
                    continue;
                }
                if (!WSDLUtils.isDocLiteral(string, bindingOperation)) continue;
                Iterator iterator2 = null;
                String string3 = this.getFirstPartName(bindingOperation);
                Map map = null;
                map = bindingOperation.getOperation().getInput().getMessage().getParts();
                if (map == null) continue;
                iterator2 = map.values().iterator();
                int n = string3 == null ? 1 : map.size();
                for (int i = 0; i < n && !bl; ++i) {
                    Part part = (Part)iterator2.next();
                    if (string3 != null && (string3 == null || !part.getName().equals(string3)) || part.getElementName() == null || !part.getElementName().equals(qName)) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public FailureDetail createFailureDetail(String string, EntryContext entryContext) {
        FailureDetail failureDetail = this.reporter.createFailureDetail();
        failureDetail.setFailureMessage(string);
        failureDetail.setElementLocation(entryContext.getMessageEntry().getElementLocation());
        return failureDetail;
    }

    protected boolean isNotApplicable(TestAssertion testAssertion) {
        boolean bl = false;
        if (testAssertion.getAdditionalEntryTypeList().getWSDLInput() != null && !testAssertion.getAdditionalEntryTypeList().getWSDLInput().equals("none") && this.analyzerContext.getServiceReference().getWSDLLocation() == null) {
            bl = true;
        }
        return bl;
    }

    public Map getHttpHeaderTokens(String string, String string2) throws WSIException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\f");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(string2);
            if (n <= 0 || n >= string3.length() - 1) continue;
            hashMap.put(string3.substring(0, n), string3.substring(n + 1).trim());
        }
        return hashMap;
    }

    public Vector getPostRequest(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\f");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2.startsWith("POST")) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            while (stringTokenizer2.hasMoreTokens()) {
                vector.add(stringTokenizer2.nextToken());
            }
        }
        return vector;
    }

    private Vector getHttpRequest(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\f");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2.startsWith("POST") || string2.startsWith("GET")) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            while (stringTokenizer2.hasMoreTokens()) {
                vector.add(stringTokenizer2.nextToken());
            }
        } else {
            vector = null;
        }
        return vector;
    }

    private String getHttpRequestType(EntryContext entryContext) {
        StringTokenizer stringTokenizer;
        String string = entryContext.getRequest().getHTTPHeaders();
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\n\r\f");
        if (stringTokenizer2.hasMoreTokens() && (stringTokenizer = new StringTokenizer(string3 = stringTokenizer2.nextToken(), " ")).hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public boolean isOneWayResponse(EntryContext entryContext) {
        boolean bl = false;
        if (entryContext.getMessageEntry().getType().equalsIgnoreCase("response") && entryContext.getMessageEntry().getMessage().length() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean messageIsDocLitSchemaValid(EntryContext entryContext) throws WSIException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        Definition[] definitionArray = this.analyzerContext.getCandidateInfo().getDefinitions();
        for (int i = 0; i < definitionArray.length; ++i) {
            arrayList.add(definitionArray[i].getDocumentBaseURI());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object4 = null;
            object3 = (String)iterator.next();
            try {
                object4 = XMLUtils.parseXMLDocumentURL((String)object3, null);
            }
            catch (Exception exception) {
                continue;
            }
            object2 = object4.getDocumentElement();
            NodeList nodeList = object2.getElementsByTagNameNS(XMLTags.ELEM_XSD_SCHEMA.getNamespaceURI(), XMLTags.ELEM_XSD_SCHEMA.getLocalPart());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = (Element)nodeList.item(i);
                this.copyNSDeclarations((Element)object2, (Element)object);
                this.copyNSDeclarations((Element)object.getParentNode(), (Element)object);
                this.replaceRelativeURIs((Element)object, (String)object3);
                arrayList2.add(object);
            }
        }
        if (!this.duplicateNamespacesDetected(arrayList2)) {
            object4 = arrayList2.iterator();
            while (object4.hasNext()) {
                object3 = (Element)object4.next();
                object2 = DOM2Writer.nodeToString((Node)object3);
                arrayList3.add(object2);
            }
            object3 = entryContext.getMessageEntryDocument().getElementsByTagNameNS(WSITag.ELEM_SOAP_BODY.getNamespaceURI(), WSITag.ELEM_SOAP_BODY.getLocalPart());
            if (object3 == null || object3.getLength() != 1) {
                return false;
            }
            object2 = ((Element)object3.item(0)).getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                Node node = object2.item(i);
                if (node.getNodeType() != 1) continue;
                try {
                    object = DOM2Writer.nodeToString((Node)node);
                    XMLUtils.parseXML((String)object, arrayList3);
                    continue;
                }
                catch (WSIException wSIException) {
                    if (wSIException.getTargetException() instanceof SAXException) {
                        throw new WSIException(wSIException.getTargetException().getMessage());
                    }
                    throw wSIException;
                }
                catch (Exception exception) {
                    throw new WSIException("Validating Parsing problem", exception);
                }
            }
        }
        return true;
    }

    private void copyNSDeclarations(Element element, Element element2) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNodeType() != 2 || !node.getNodeName().startsWith("xmlns:")) continue;
            String string = node.getNodeName();
            if (element2.getNodeName().startsWith(string.substring(string.indexOf(":") + 1) + ":")) continue;
            String string2 = node.getNodeValue();
            element2.setAttribute(node.getNodeName(), node.getNodeValue());
        }
    }

    private void replaceRelativeURIs(Element element, String string) {
        NodeList nodeList = element.getElementsByTagNameNS(XMLTags.ELEM_XSD_IMPORT.getNamespaceURI(), XMLTags.ELEM_XSD_IMPORT.getLocalPart());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            Attr attr = XMLUtils.getAttribute(element2, XMLTags.ATTR_XSD_SCHEMALOCATION);
            if (attr == null) continue;
            URI uRI = null;
            try {
                uRI = new URI(attr.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRI != null) continue;
            String string2 = string.substring(0, string.lastIndexOf("/") + 1) + attr.getValue();
            try {
                uRI = new URI(string2);
                attr.setValue(uRI.toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BindingOperation getOperationMatch(EntryType entryType, Document document) {
        BindingOperation bindingOperation = null;
        try {
            BindingOperation[] bindingOperationArray;
            BindingOperation[] bindingOperationArray2;
            BindingOperation[] bindingOperationArray3;
            QName qName = this.getOperationFromMessage(document);
            if (qName != null && (bindingOperation = this.getOperationMatch(entryType, qName, bindingOperationArray3 = this.getMatchingBindingOps("rpc", this.analyzerContext.getCandidateInfo().getBindings()))) == null && (bindingOperationArray2 = this.getDocLitOperations(entryType, qName, bindingOperationArray = this.getMatchingBindingOps("document", this.analyzerContext.getCandidateInfo().getBindings()))).length == 1) {
                bindingOperation = bindingOperationArray2[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bindingOperation;
    }

    public BindingOperation getOperationMatch(EntryType entryType, Document document, BindingOperation[] bindingOperationArray) {
        QName qName = this.getOperationFromMessage(document);
        return this.getOperationMatch(entryType, qName, bindingOperationArray);
    }

    public BindingOperation getOperationMatch(EntryType entryType, QName qName, BindingOperation[] bindingOperationArray) {
        for (int i = 0; i < bindingOperationArray.length; ++i) {
            String string = null;
            List list = null;
            BindingOperation bindingOperation = bindingOperationArray[i];
            if (entryType.isType("requestMessage") && bindingOperation.getOperation().getInput() != null) {
                string = bindingOperation.getOperation().getName();
                list = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryType.isType("responseMessage") && bindingOperation.getOperation().getOutput() != null) {
                string = bindingOperation.getOperation().getName() + "Response";
                list = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            SOAPBody sOAPBody = this.getSoapBody(list);
            QName qName2 = sOAPBody == null ? new QName(string) : new QName(sOAPBody.getNamespaceURI(), string);
            if (qName == null || !qName.equals(qName2)) continue;
            return bindingOperation;
        }
        return null;
    }

    public BindingOperation getOperationPartsMatch(EntryType entryType, Document document, BindingOperation[] bindingOperationArray) {
        Map map = this.getPartListFromMessage(document);
        for (int i = 0; i < bindingOperationArray.length; ++i) {
            Message message = null;
            List list = null;
            BindingOperation bindingOperation = bindingOperationArray[i];
            if (entryType.isType("requestMessage") && bindingOperation.getOperation().getInput() != null) {
                message = bindingOperation.getOperation().getInput().getMessage();
                list = bindingOperation.getBindingInput().getExtensibilityElements();
            } else if (entryType.isType("responseMessage") && bindingOperation.getOperation().getOutput() != null) {
                message = bindingOperation.getOperation().getOutput().getMessage();
                list = bindingOperation.getBindingOutput().getExtensibilityElements();
            }
            if (!this.sameParts(map, message, this.getSoapHeader(list))) continue;
            return bindingOperation;
        }
        return null;
    }

    private BindingOperation getOperationPartsMatch(Document document, Document document2, BindingOperation[] bindingOperationArray) {
        Map map = this.getPartListFromMessage(document);
        Map map2 = this.getPartListFromMessage(document2);
        for (int i = 0; i < bindingOperationArray.length; ++i) {
            Message message = null;
            Message message2 = null;
            BindingOperation bindingOperation = bindingOperationArray[i];
            if (bindingOperation.getOperation().getInput() != null) {
                message = bindingOperation.getOperation().getInput().getMessage();
            }
            if (bindingOperation.getOperation().getOutput() != null) {
                message2 = bindingOperation.getOperation().getOutput().getMessage();
            }
            if (!this.sameParts(map, message, this.getSoapHeader(bindingOperation.getBindingInput().getExtensibilityElements()))) continue;
            if (document2 != null && this.isFault(document2)) {
                return bindingOperation;
            }
            if (!this.sameParts(map2, message2, this.getSoapHeader(bindingOperation.getBindingOutput().getExtensibilityElements()))) continue;
            return bindingOperation;
        }
        return null;
    }

    private SOAPBody getSoapBody(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (extensibilityElement.getElementType().equals(WSITag.WSDL_SOAP_BODY)) {
                    return (SOAPBody)extensibilityElement;
                }
                if (!extensibilityElement.getElementType().equals(WSITag.WSDL_MIME_MULTIPART)) continue;
                List list2 = ((MIMEMultipartRelated)extensibilityElement).getMIMEParts();
                for (int j = 0; j < list2.size(); ++j) {
                    SOAPBody sOAPBody = this.getSoapBody(((MIMEPart)list2.get(j)).getExtensibilityElements());
                    if (sOAPBody == null) continue;
                    return sOAPBody;
                }
            }
        }
        return null;
    }

    private SOAPHeader getSoapHeader(List list) {
        SOAPHeader sOAPHeader = null;
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && sOAPHeader == null) {
                try {
                    sOAPHeader = (SOAPHeader)iterator.next();
                }
                catch (ClassCastException classCastException) {}
            }
        }
        return sOAPHeader;
    }

    private String getFirstPartName(BindingOperation bindingOperation) {
        String string = null;
        List list = null;
        Iterator iterator = null;
        list = bindingOperation.getBindingInput().getExtensibilityElements();
        if (list != null) {
            List list2 = null;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext() && string == null) {
                Object e = iterator2.next();
                if (!(e instanceof SOAPBody) || (list2 = ((SOAPBody)e).getParts()) == null || !(iterator = list2.iterator()).hasNext()) continue;
                string = (String)iterator.next();
            }
        }
        return string;
    }

    public BindingOperation[] getDocLitOperations(EntryType entryType, QName qName, BindingOperation[] bindingOperationArray) {
        if (entryType.isType(EntryType.ENTRY_TYPE_REQUEST)) {
            return this.getInputDocLitOperations(qName, bindingOperationArray);
        }
        if (entryType.isType(EntryType.ENTRY_TYPE_RESPONSE)) {
            return this.getOutputDocLitOperations(qName, bindingOperationArray);
        }
        return null;
    }

    private BindingOperation[] getInputDocLitOperations(QName qName, BindingOperation[] bindingOperationArray) {
        Vector<BindingOperation> vector = new Vector<BindingOperation>();
        block0: for (int i = 0; i < bindingOperationArray.length; ++i) {
            if (bindingOperationArray[i].getOperation().getInput() == null) continue;
            Message message = bindingOperationArray[i].getOperation().getInput().getMessage();
            if (qName == null) {
                if (!message.getParts().isEmpty()) continue;
                vector.add(bindingOperationArray[i]);
                continue;
            }
            Iterator iterator = message.getParts().values().iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                if (!qName.equals(part.getElementName())) continue;
                vector.add(bindingOperationArray[i]);
                continue block0;
            }
        }
        return vector.toArray(new BindingOperation[0]);
    }

    private BindingOperation[] getOutputDocLitOperations(QName qName, BindingOperation[] bindingOperationArray) {
        Vector<BindingOperation> vector = new Vector<BindingOperation>();
        block0: for (int i = 0; i < bindingOperationArray.length; ++i) {
            if (bindingOperationArray[i].getOperation().getOutput() == null) continue;
            Message message = bindingOperationArray[i].getOperation().getOutput().getMessage();
            if (qName == null) {
                if (!message.getParts().isEmpty()) continue;
                vector.add(bindingOperationArray[i]);
                continue;
            }
            Iterator iterator = message.getParts().values().iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                if (!qName.equals(part.getElementName())) continue;
                vector.add(bindingOperationArray[i]);
                continue block0;
            }
        }
        return vector.toArray(new BindingOperation[0]);
    }

    private boolean sameParts(HashSet hashSet, Map map) {
        Iterator iterator = map.values().iterator();
        HashSet<String> hashSet2 = new HashSet<String>();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            hashSet2.add(part.getName());
        }
        return hashSet2.equals(hashSet);
    }

    private boolean sameParts(Map map, Message message, SOAPHeader sOAPHeader) {
        Object object;
        Iterator<Object> iterator;
        String string = null;
        if (sOAPHeader != null) {
            string = sOAPHeader.getPart();
        }
        if (map == null && message == null) {
            return true;
        }
        if (map == null || message == null) {
            return false;
        }
        Vector<QName> vector = new Vector<QName>();
        Map map2 = null;
        if (message.getParts() != null) {
            map2 = message.getParts();
            iterator = map2.values().iterator();
            while (iterator.hasNext()) {
                object = (Part)iterator.next();
                if (object.getName().equals(string)) continue;
                vector.add(new QName(object.getName()));
            }
        }
        if (vector.isEmpty() && map.isEmpty()) {
            return true;
        }
        if (vector.containsAll(map.keySet()) && vector.size() == map.size()) {
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Part part;
                object = (QName)iterator.next();
                QName qName = (QName)map.get(object);
                if (qName == null || map2 == null || this.isDerivedType(qName, (part = (Part)map2.get(((QName)object).getLocalPart())).getTypeName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isDerivedType(QName qName, QName qName2) {
        if (qName == null || qName2 == null) {
            return false;
        }
        if (qName.equals(qName2)) {
            return true;
        }
        Iterator iterator = this.wsdlDocument.getSchemas().values().iterator();
        while (iterator.hasNext()) {
            XSModel xSModel = (XSModel)iterator.next();
            XSTypeDefinition xSTypeDefinition = xSModel.getTypeDefinition(qName.getLocalPart(), qName.getNamespaceURI());
            if (xSTypeDefinition == null || !xSTypeDefinition.derivedFrom(qName2.getNamespaceURI(), qName2.getLocalPart(), (short)0)) continue;
            return true;
        }
        return false;
    }

    public Element getSoapBodyChild(Document document) {
        Element element;
        NodeList nodeList;
        Element element2 = null;
        if (document != null && (nodeList = (element = document.getDocumentElement()).getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && nodeList.getLength() > 0) {
            Element element3 = (Element)nodeList.item(0);
            NodeList nodeList2 = element3.getChildNodes();
            for (int i = 0; i < nodeList2.getLength() && element2 == null; ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Element)) continue;
                element2 = (Element)node;
            }
        }
        return element2;
    }

    public boolean isFault(Document document) {
        boolean bl = false;
        if (document != null) {
            Element element = document.getDocumentElement();
            bl = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault").getLength() > 0;
        }
        return bl;
    }

    public boolean containsSoapBodyWithChild(Document document) {
        boolean bl = false;
        if (document != null) {
            bl = this.getSoapBodyChild(document) != null;
        }
        return bl;
    }

    public String getSoapAction(String string) throws WSIException {
        String string2 = null;
        if (string != null) {
            string2 = (String)this.getHttpHeaderTokens(string, ":").get("SOAPAction");
        }
        return string2;
    }

    private QName getOperationFromMessage(Document document) {
        Element element;
        NodeList nodeList;
        QName qName = null;
        if (document != null && (nodeList = (element = document.getDocumentElement()).getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Element)) continue;
                qName = new QName(node.getNamespaceURI(), node.getLocalName());
            }
        }
        return qName;
    }

    private Map getPartListFromMessage(Document document) {
        Element element;
        NodeList nodeList;
        HashMap<QName, QName> hashMap = new HashMap<QName, QName>();
        if (document != null && (nodeList = (element = document.getDocumentElement()).getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Element)) continue;
                NodeList nodeList3 = node.getChildNodes();
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    Node node2 = nodeList3.item(j);
                    if (!(node2 instanceof Element)) continue;
                    Attr attr = XMLUtils.getAttribute((Element)node2, new QName("http://www.w3.org/2001/XMLSchema-instance", "type"));
                    QName qName = null;
                    try {
                        if (attr != null) {
                            qName = DOMUtils.getQName((String)attr.getNodeValue(), (Element)((Element)node2));
                        }
                    }
                    catch (WSDLException wSDLException) {
                        // empty catch block
                    }
                    hashMap.put(new QName(node2.getNamespaceURI(), node2.getLocalName()), qName);
                }
            }
        }
        return hashMap;
    }

    public BindingOperation[] getMatchingBindingOps(String string, Binding[] bindingArray) throws WSIException {
        HashSet<BindingOperation> hashSet = new HashSet<BindingOperation>();
        for (int i = 0; i < bindingArray.length; ++i) {
            Binding binding = bindingArray[i];
            List list = binding.getBindingOperations();
            if (list == null) continue;
            Iterator iterator = binding.getBindingOperations().iterator();
            while (iterator.hasNext()) {
                SOAPBinding sOAPBinding;
                String string2;
                BindingOperation bindingOperation = (BindingOperation)iterator.next();
                SOAPOperation sOAPOperation = WSDLValidatorImpl.getSoapOperation(bindingOperation);
                if ((sOAPOperation == null || (string2 = sOAPOperation.getStyle()) == null) && (string2 = (sOAPBinding = WSDLValidatorImpl.getSoapBinding(binding)).getStyle()) == null) {
                    string2 = "document";
                }
                if (!string2.equals(string)) continue;
                hashSet.add(bindingOperation);
            }
        }
        return hashSet.toArray(new BindingOperation[0]);
    }

    public boolean isLiteral(List list) {
        SOAPBody sOAPBody = this.getSOAPBody(list);
        return sOAPBody != null && sOAPBody.getUse().equals("literal");
    }

    public List orderPartNames(List list, List list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list3 = null;
        SOAPBody sOAPBody = this.getSOAPBody(list2);
        if (sOAPBody != null) {
            list3 = sOAPBody.getParts();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = ((Part)iterator.next()).getName();
            if (list3 != null && !list3.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public SOAPBody getSOAPBody(List list) {
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPBody)) continue;
            return (SOAPBody)e;
        }
        return null;
    }

    public List resolveSameNamespaces(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String string = element.getAttribute("targetNamespace");
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
            List list2 = this.getSchemasWithSameNamespace(list, string);
            if (list2.size() == 1) {
                arrayList2.add(element);
                continue;
            }
            this.copyNSDeclarations((Element)element.getParentNode(), element);
            String string2 = DOM2Writer.nodeToString((Node)element);
        }
        return null;
    }

    public List getSchemasWithSameNamespace(List list, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String string2 = element.getAttribute("targetNamespace");
            if (string2 == null) {
                string2 = "";
            }
            if (!string2.equals(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    public boolean duplicateNamespacesDetected(List list) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String string = element.getAttribute("targetNamespace");
            if (string == null) {
                string = "";
            }
            if (arrayList.contains(string)) {
                bl = true;
                break;
            }
            arrayList.add(string);
        }
        return bl;
    }
}

