/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.log.impl;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.wsi.WSIException;
import org.wsi.test.ToolEnvironment;
import org.wsi.test.ToolInfo;
import org.wsi.test.log.LogReader;
import org.wsi.test.log.MessageEntry;
import org.wsi.test.log.MessageEntryHandler;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.log.impl.MessageEntryImpl;
import org.wsi.test.log.impl.MimePartImpl;
import org.wsi.test.log.impl.MimePartsImpl;
import org.wsi.test.monitor.config.impl.CommentImpl;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.report.ArtifactReference;
import org.wsi.test.report.impl.ArtifactReferenceImpl;
import org.wsi.test.report.impl.EntryImpl;
import org.wsi.test.util.EntryType;
import org.wsi.util.Utils;
import org.wsi.xml.XMLUtils;
import org.wsi.xml.dom.ElementLocation;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LogReaderImpl
implements LogReader {
    private String documentURI;
    private int firstLogElement = 0;
    private int elementCount = 0;
    private boolean bMonitorFirst = false;
    private WSIException wsiException = null;

    public void readLog(String string, MessageEntryHandler messageEntryHandler) throws WSIException {
        this.readLog(new InputSource(string), messageEntryHandler);
    }

    public void readLog(Reader reader, MessageEntryHandler messageEntryHandler) throws WSIException {
        this.readLog(new InputSource(reader), messageEntryHandler);
    }

    protected void readLog(InputSource inputSource, MessageEntryHandler messageEntryHandler) throws WSIException {
        try {
            XMLReader xMLReader = XMLUtils.getXMLReader();
            xMLReader.setContentHandler(new LogFileHandler(messageEntryHandler));
            xMLReader.parse(inputSource);
            if (this.wsiException != null) {
                // empty if block
            }
            if (!this.bMonitorFirst) {
                throw new WSIException("The Element \"monitor\" is not the first child of the Element \"log\"");
            }
        }
        catch (Exception exception) {
            throw new WSIException("An error occurred while processing the message log file.", exception);
        }
    }

    public String getLocation() {
        return this.documentURI;
    }

    public void setLocation(String string) {
        this.documentURI = string;
    }

    private class LogFileHandler
    extends DefaultHandler {
        private String id;
        private String conversationID;
        private String type;
        private String timestamp;
        private StringBuffer senderHostAndPort = null;
        private StringBuffer receiverHostAndPort = null;
        private StringBuffer messageContent = null;
        private StringBuffer httpHeaders = null;
        private StringBuffer boundary = null;
        private StringBuffer mimeHeaders = null;
        private StringBuffer mimeContent = null;
        private MimeParts mimeParts = null;
        private List boundaries = null;
        private int bom = 0;
        private String logTimestamp = null;
        private StringBuffer monitorComment;
        private boolean ignoreComment = false;
        private String currentElement;
        private ElementLocation entryElementLocation = null;
        private ToolInfo toolInfo = null;
        private Vector messageEntryList = new Vector();
        private MessageEntryHandler logEntryHandler = null;
        private Locator locator = null;

        public LogFileHandler(MessageEntryHandler messageEntryHandler) {
            this.logEntryHandler = messageEntryHandler;
            this.toolInfo = new ToolInfo();
            this.toolInfo.setToolEnvironment(new ToolEnvironment());
        }

        public void startDocument() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (LogReaderImpl.this.elementCount == 2 && LogReaderImpl.this.firstLogElement == 1) {
                LogReaderImpl.this.bMonitorFirst = true;
            }
            LogReaderImpl.this.elementCount++;
            if (string2 == "log") {
                this.logTimestamp = attributes.getValue("timestamp");
            } else if (string2 == "configuration" && string == "http://www.ws-i.org/testing/2003/03/monitorConfig/") {
                this.ignoreComment = false;
            } else if (string2 == "comment" && string == "http://www.ws-i.org/testing/2003/03/monitorConfig/") {
                if (!this.ignoreComment) {
                    this.currentElement = "comment";
                    this.monitorComment = new StringBuffer();
                }
            } else if (string2 == "redirect" && string == "http://www.ws-i.org/testing/2003/03/monitorConfig/") {
                this.ignoreComment = true;
                this.monitorComment = null;
            } else if (string2 == "monitor") {
                LogReaderImpl.this.firstLogElement++;
                this.toolInfo.setName("monitor");
                this.toolInfo.setVersion(attributes.getValue("version"));
                this.toolInfo.setReleaseDate(attributes.getValue("releaseDate"));
            } else if (string2 == "implementer") {
                this.currentElement = "implementer";
                this.toolInfo.setImplementer(attributes.getValue("name"));
                this.toolInfo.setLocation(attributes.getValue("location"));
            } else if (string2 == "runtime") {
                this.currentElement = "runtime";
                this.toolInfo.getToolEnvironment().setRuntimeName(attributes.getValue("name"));
                this.toolInfo.getToolEnvironment().setRuntimeVersion(attributes.getValue("version"));
            } else if (string2 == "operatingSystem") {
                this.currentElement = "operatingSystem";
                this.toolInfo.getToolEnvironment().setOSName(attributes.getValue("name"));
                this.toolInfo.getToolEnvironment().setOSVersion(attributes.getValue("version"));
            } else if (string2 == "xmlParser") {
                this.currentElement = "xmlParser";
                this.toolInfo.getToolEnvironment().setXMLParserName(attributes.getValue("name"));
                this.toolInfo.getToolEnvironment().setXMLParserVersion(attributes.getValue("version"));
            } else if (string2 == "messageEntry") {
                this.currentElement = "messageEntry";
                this.entryElementLocation = new ElementLocation(this.locator);
                this.timestamp = attributes.getValue("timestamp");
                this.conversationID = attributes.getValue("conversationID");
                this.id = attributes.getValue("ID");
                this.type = attributes.getValue("type");
            } else if (string2 == "httpHeaders") {
                this.httpHeaders = new StringBuffer();
                this.currentElement = "httpHeaders";
            } else if (string2 == "messageContent") {
                this.messageContent = new StringBuffer();
                this.mimeParts = null;
                this.currentElement = "messageContent";
                String string4 = attributes.getValue("BOM");
                this.bom = string4 != null ? Integer.valueOf(string4) : 0;
            } else if (string2 == "messageContentWithAttachments") {
                this.messageContent = null;
                this.mimeParts = new MimePartsImpl();
                String string5 = attributes.getValue("BOM");
                this.bom = string5 != null ? Integer.valueOf(string5) : 0;
            } else if (string2 == "mimePart") {
                if (this.boundaries == null) {
                    this.boundaries = new ArrayList(2);
                } else {
                    this.boundaries.clear();
                }
            } else if (string2 == "boundaryString") {
                this.boundary = new StringBuffer();
                this.currentElement = "boundaryString";
            } else if (string2 == "mimeHeaders") {
                this.mimeHeaders = new StringBuffer();
                this.currentElement = "mimeHeaders";
            } else if (string2 == "mimeContent") {
                this.mimeContent = new StringBuffer();
                this.currentElement = "mimeContent";
            } else if (string2 == "senderHostAndPort") {
                this.senderHostAndPort = new StringBuffer();
                this.currentElement = "senderHostAndPort";
            } else if (string2 == "receiverHostAndPort") {
                this.receiverHostAndPort = new StringBuffer();
                this.currentElement = "receiverHostAndPort";
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            int n3 = n;
            int n4 = n2;
            if (n > 0 && cArray[n - 1] == '\r' && cArray[n] == '\n') {
                ++n3;
                --n4;
            }
            if (this.monitorComment != null && this.currentElement == "comment") {
                this.monitorComment.append(cArray, n, n2);
            } else if (this.messageContent != null && this.currentElement == "messageContent") {
                this.messageContent.append(cArray, n, n2);
            } else if (this.httpHeaders != null && this.currentElement == "httpHeaders") {
                this.httpHeaders.append(cArray, n, n2);
            } else if (this.boundary != null && this.currentElement == "boundaryString") {
                this.boundary.append(cArray, n3, n4);
            } else if (this.mimeHeaders != null && this.currentElement == "mimeHeaders") {
                this.mimeHeaders.append(cArray, n3, n4);
            } else if (this.mimeContent != null && this.currentElement == "mimeContent") {
                this.mimeContent.append(cArray, n3, n4);
            } else if (this.senderHostAndPort != null && this.currentElement == "senderHostAndPort") {
                this.senderHostAndPort.append(cArray, n, n2);
            } else if (this.receiverHostAndPort != null && this.currentElement == "receiverHostAndPort") {
                this.receiverHostAndPort.append(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string2 == "comment" && string == "http://www.ws-i.org/testing/2003/03/monitorConfig/") {
                if (this.monitorComment != null) {
                    ArtifactReferenceImpl artifactReferenceImpl = new ArtifactReferenceImpl();
                    artifactReferenceImpl.setTimestamp(this.logTimestamp);
                    CommentImpl commentImpl = new CommentImpl();
                    commentImpl.setText(this.monitorComment.toString());
                    artifactReferenceImpl.setDocumentElement(commentImpl, "wsi-monConfig");
                    this.processArtifactReference(artifactReferenceImpl);
                }
            } else if (string2 == "boundaryString") {
                this.boundaries.add(this.boundary.toString());
            } else if (string2 == "mimePart") {
                MimePartImpl mimePartImpl = new MimePartImpl();
                mimePartImpl.setHeaders(this.mimeHeaders.toString());
                mimePartImpl.setContent(this.mimeContent.toString());
                mimePartImpl.setBoundaryStrings(this.boundaries.toArray(new String[0]));
                this.mimeParts.addPart(mimePartImpl);
            } else if (string2 == "messageEntry") {
                if ("request".equalsIgnoreCase(this.type)) {
                    MessageEntry messageEntry = this.createMessageEntry(this.id, this.conversationID, this.type, this.timestamp, this.senderHostAndPort.toString(), this.receiverHostAndPort.toString(), this.messageContent == null ? "" : this.messageContent.toString(), this.httpHeaders.toString(), this.mimeParts, this.entryElementLocation);
                    this.messageEntryList.add(messageEntry);
                } else if ("response".equalsIgnoreCase(this.type)) {
                    MessageEntry messageEntry = this.createMessageEntry(this.id, this.conversationID, this.type, this.timestamp, this.senderHostAndPort.toString(), this.receiverHostAndPort.toString(), this.messageContent == null ? "" : this.messageContent.toString(), this.httpHeaders.toString(), this.mimeParts, this.entryElementLocation);
                    this.messageEntryList.add(messageEntry);
                    if (this.logEntryHandler != null) {
                        EntryContext entryContext;
                        EntryImpl entryImpl;
                        MessageEntry messageEntry2 = this.findRelatedRequest(messageEntry);
                        if (messageEntry2 != null) {
                            entryImpl = new EntryImpl();
                            entryImpl.setEntryType(EntryType.getEntryType("requestMessage"));
                            entryImpl.setReferenceID(messageEntry2.getId());
                            entryImpl.setEntryDetail(messageEntry2);
                            entryContext = new EntryContext(entryImpl, messageEntry2, messageEntry);
                            if (entryContext != null) {
                                this.processLogEntry(entryContext);
                            }
                        }
                        entryImpl = new EntryImpl();
                        entryImpl.setEntryType(EntryType.getEntryType("responseMessage"));
                        entryImpl.setReferenceID(messageEntry.getId());
                        entryImpl.setEntryDetail(messageEntry);
                        entryContext = new EntryContext(entryImpl, messageEntry2, messageEntry);
                        if (entryContext != null) {
                            this.processLogEntry(entryContext);
                        }
                    }
                }
            }
            this.currentElement = null;
        }

        public void endDocument() {
        }

        public void processLogEntry(EntryContext entryContext) {
            try {
                this.logEntryHandler.processLogEntry(entryContext);
            }
            catch (Exception exception) {
                LogReaderImpl.this.wsiException = new WSIException("An error occurred while validating the message logEntry: " + entryContext.getMessageEntry().getId(), exception);
            }
        }

        private void processArtifactReference(ArtifactReference artifactReference) {
            try {
                this.logEntryHandler.processArtifactReference(artifactReference);
            }
            catch (Exception exception) {
                LogReaderImpl.this.wsiException = new WSIException("An error occurred while processing the artifact reference: " + artifactReference.toString(), exception);
            }
        }

        public MessageEntry findRelatedRequest(MessageEntry messageEntry) {
            for (int i = this.messageEntryList.size() - 1; i >= 0; --i) {
                MessageEntry messageEntry2 = (MessageEntry)this.messageEntryList.get(i);
                if (messageEntry.equals(messageEntry2) || !messageEntry.getConversationId().equals(messageEntry2.getConversationId())) continue;
                if (messageEntry2.getType().equals("request")) {
                    return messageEntry2;
                }
                return null;
            }
            return null;
        }

        private MessageEntry createMessageEntry(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, MimeParts mimeParts, ElementLocation elementLocation) {
            MessageEntryImpl messageEntryImpl = new MessageEntryImpl();
            messageEntryImpl.setId(string);
            messageEntryImpl.setConversationId(this.conversationID);
            messageEntryImpl.setType(string3);
            messageEntryImpl.setTimestamp(string4);
            messageEntryImpl.setSenderHostAndPort(string5);
            messageEntryImpl.setReceiverHostAndPort(string6);
            messageEntryImpl.setHTTPHeaders(string8);
            messageEntryImpl.setBOM(this.bom);
            messageEntryImpl.setElementLocation(elementLocation);
            String string9 = null;
            if (mimeParts == null) {
                string9 = Utils.getXMLEncoding(string7);
                messageEntryImpl.setMessage(string7);
                messageEntryImpl.setMimeContent(false);
            } else {
                messageEntryImpl.setMimeParts(mimeParts);
                MimePart mimePart = Utils.findRootPart(string8, mimeParts.getParts());
                if (mimePart != null) {
                    string9 = Utils.getXMLEncoding(mimePart.getContent());
                    mimeParts.setRootPart(mimePart);
                }
                messageEntryImpl.setMimeContent(true);
            }
            if (string9 == null || string9.equals("")) {
                string9 = "UTF-8";
            }
            messageEntryImpl.setEncoding(string9);
            return messageEntryImpl;
        }
    }
}

