/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.analyzer.config.impl;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.wsi.WSIException;
import org.wsi.test.analyzer.config.AnalyzerConfig;
import org.wsi.test.analyzer.config.AssertionResultType;
import org.wsi.test.analyzer.config.AssertionResultsOption;
import org.wsi.test.analyzer.config.UDDIReference;
import org.wsi.test.analyzer.config.WSDLElement;
import org.wsi.test.analyzer.config.WSDLReference;
import org.wsi.test.analyzer.config.impl.AnalyzerConfigReaderImpl;
import org.wsi.test.analyzer.config.impl.AssertionResultsOptionImpl;
import org.wsi.test.analyzer.config.impl.UDDIReferenceImpl;
import org.wsi.test.analyzer.config.impl.WSDLElementImpl;
import org.wsi.test.analyzer.config.impl.WSDLReferenceImpl;
import org.wsi.test.common.AddStyleSheet;
import org.wsi.test.common.impl.AddStyleSheetImpl;
import org.wsi.util.MessageList;
import org.wsi.util.Utils;

public class AnalyzerConfigImpl
implements AnalyzerConfig {
    protected MessageList messageList = null;
    protected String configURI = null;
    protected String description = null;
    protected boolean verbose = false;
    protected AssertionResultsOption assertionResultsOption = new AssertionResultsOptionImpl();
    protected String reportURI = "report.xml";
    protected boolean replaceReport = false;
    protected AddStyleSheet addStyleSheet;
    protected String testAssertionsDocumentURI = "../common/profiles/SSBP10_BP11_TAD.xml";
    protected String logURI = null;
    protected String correlationType = "operation";
    protected WSDLReference wsdlReference = null;
    protected UDDIReference uddiReference = null;

    public AnalyzerConfigImpl() {
    }

    public AnalyzerConfigImpl(String string, boolean bl, AssertionResultsOption assertionResultsOption, String string2, boolean bl2, AddStyleSheet addStyleSheet, String string3, String string4, String string5, WSDLReference wSDLReference, UDDIReference uDDIReference) {
        this.description = string;
        this.verbose = bl;
        this.assertionResultsOption = assertionResultsOption;
        this.reportURI = string2;
        this.replaceReport = bl2;
        this.addStyleSheet = addStyleSheet;
        this.testAssertionsDocumentURI = string3;
        this.logURI = string4;
        this.correlationType = string5;
        this.wsdlReference = wSDLReference;
        this.uddiReference = uDDIReference;
    }

    public void init(MessageList messageList) {
        this.messageList = messageList;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean getVerboseOption() {
        return this.verbose;
    }

    public void setVerboseOption(boolean bl) {
        this.verbose = bl;
    }

    public AssertionResultsOption getAssertionResultsOption() {
        return this.assertionResultsOption;
    }

    public void setAssertionResultsOption(AssertionResultsOption assertionResultsOption) {
        this.assertionResultsOption = assertionResultsOption;
    }

    public String getReportLocation() {
        return this.reportURI;
    }

    public void setReportLocation(String string) {
        this.reportURI = string;
    }

    public boolean getReplaceReport() {
        return this.replaceReport;
    }

    public void setReplaceReport(boolean bl) {
        this.replaceReport = bl;
    }

    public AddStyleSheet getAddStyleSheet() {
        return this.addStyleSheet;
    }

    public void setAddStyleSheet(AddStyleSheet addStyleSheet) {
        this.addStyleSheet = addStyleSheet;
    }

    public String getTestAssertionsDocumentLocation() {
        return this.testAssertionsDocumentURI;
    }

    public void setTestAssertionsDocumentLocation(String string) {
        this.testAssertionsDocumentURI = string;
    }

    public String getLogLocation() {
        return this.logURI;
    }

    public void setLogLocation(String string) {
        this.logURI = string;
    }

    public boolean isLogSet() {
        return this.logURI != null;
    }

    public String getCorrelationType() {
        return this.correlationType;
    }

    public void setCorrelationType(String string) {
        this.correlationType = string;
    }

    public boolean isWSDLReferenceSet() {
        return this.wsdlReference != null;
    }

    public WSDLReference getWSDLReference() {
        return this.wsdlReference;
    }

    public void setWSDLReference(WSDLReference wSDLReference) {
        this.wsdlReference = wSDLReference;
    }

    public WSDLElement getWSDLElement() {
        return this.wsdlReference == null ? null : this.wsdlReference.getWSDLElement();
    }

    public String getServiceLocation() {
        return this.wsdlReference == null ? null : this.wsdlReference.getServiceLocation();
    }

    public String getWSDLLocation() {
        return this.wsdlReference == null ? null : this.wsdlReference.getWSDLLocation();
    }

    public boolean isUDDIReferenceSet() {
        return this.uddiReference != null;
    }

    public UDDIReference getUDDIReference() {
        return this.uddiReference;
    }

    public void setUDDIReference(UDDIReference uDDIReference) {
        this.uddiReference = uDDIReference;
    }

    public String getLocation() {
        return this.configURI;
    }

    public void setLocation(String string) {
        this.configURI = string;
    }

    public String toXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("") && !string2.endsWith(":")) {
            string2 = string2 + ":";
        }
        printWriter.println("    <" + string2 + "configuration" + ">");
        printWriter.print("      <" + string2 + "verbose" + ">");
        printWriter.print(this.getVerboseOption());
        printWriter.println("</" + string2 + "verbose" + ">");
        printWriter.print(this.assertionResultsOption.toXMLString(string2));
        printWriter.print("        <" + string2 + "reportFile" + " ");
        printWriter.print("replace=\"" + this.getReplaceReport() + "\" ");
        printWriter.println("location=\"" + this.getReportLocation() + "\">");
        printWriter.print(this.getAddStyleSheet().toXMLString(string));
        printWriter.println("        </" + string2 + "reportFile" + ">");
        printWriter.print("        <" + string2 + "testAssertionsFile" + ">");
        printWriter.print(this.getTestAssertionsDocumentLocation());
        printWriter.println("</" + string2 + "testAssertionsFile" + ">");
        printWriter.print("        <" + string2 + "logFile");
        printWriter.print(" correlationType=\"" + this.correlationType + "\">");
        printWriter.print(this.getLogLocation());
        printWriter.println("</" + string2 + "logFile" + ">");
        if (this.wsdlReference != null) {
            printWriter.print(this.getWSDLReference().toXMLString(string2));
        }
        if (this.uddiReference != null) {
            printWriter.print(this.getUDDIReference().toXMLString(string2));
        }
        printWriter.println("    </" + string2 + "configuration" + ">");
        return stringWriter.toString();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("  verbose .................... " + this.verbose);
        printWriter.print(((Object)this.assertionResultsOption).toString());
        printWriter.println("  Report File:");
        printWriter.println("    replace .................. " + this.replaceReport);
        printWriter.println("    location ................. " + this.reportURI);
        if (this.addStyleSheet != null) {
            printWriter.println("    Style Sheet:");
            if (this.addStyleSheet.getHref() != null) {
                printWriter.println("      href ................... " + this.addStyleSheet.getHref());
            }
            if (this.addStyleSheet.getType() != null) {
                printWriter.println("      type ................... " + this.addStyleSheet.getType());
            }
            if (this.addStyleSheet.getTitle() != null) {
                printWriter.println("      title .................. " + this.addStyleSheet.getTitle());
            }
            if (this.addStyleSheet.getMedia() != null) {
                printWriter.println("      media .................. " + this.addStyleSheet.getMedia());
            }
            if (this.addStyleSheet.getCharset() != null) {
                printWriter.println("      charset ................ " + this.addStyleSheet.getCharset());
            }
            if (this.addStyleSheet.getAlternate() != null) {
                printWriter.println("      alternate .............. " + this.addStyleSheet.getAlternate());
            }
        }
        printWriter.println("  testAssertionsFile ......... " + this.testAssertionsDocumentURI);
        if (this.logURI != null) {
            printWriter.println("  Message Log File:");
            printWriter.println("    location ................. " + this.logURI);
            printWriter.println("    correlationType .......... " + this.correlationType);
        }
        if (this.isWSDLReferenceSet()) {
            printWriter.print(this.wsdlReference.toString());
        }
        if (this.isUDDIReferenceSet()) {
            printWriter.print(this.uddiReference.toString());
        }
        if (this.description != null) {
            printWriter.println("  description ................ " + this.description);
        }
        return stringWriter.toString();
    }

    private void setConfig(AnalyzerConfig analyzerConfig) {
        this.configURI = analyzerConfig.getLocation();
        this.description = analyzerConfig.getDescription();
        this.verbose = analyzerConfig.getVerboseOption();
        this.assertionResultsOption = analyzerConfig.getAssertionResultsOption();
        this.reportURI = analyzerConfig.getReportLocation();
        this.replaceReport = analyzerConfig.getReplaceReport();
        this.logURI = analyzerConfig.getLogLocation();
        this.correlationType = analyzerConfig.getCorrelationType();
        this.testAssertionsDocumentURI = analyzerConfig.getTestAssertionsDocumentLocation();
        this.addStyleSheet = analyzerConfig.getAddStyleSheet();
        this.wsdlReference = analyzerConfig.getWSDLReference();
        this.uddiReference = analyzerConfig.getUDDIReference();
    }

    public void parseArgs(String[] stringArray, boolean bl) throws WSIException {
        int n;
        WSDLReference wSDLReference = null;
        UDDIReference uDDIReference = null;
        AnalyzerConfigReaderImpl analyzerConfigReaderImpl = new AnalyzerConfigReaderImpl();
        analyzerConfigReaderImpl.init(this.messageList);
        AnalyzerConfig analyzerConfig = null;
        AssertionResultsOption assertionResultsOption = null;
        if (stringArray.length == 0) {
            throw new IllegalArgumentException(this.getMessage("usage01", "Usage: Analyzer -config <configFilename>"));
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase("-config") && !stringArray[n].equals("-c")) continue;
            analyzerConfig = analyzerConfigReaderImpl.readAnalyzerConfig(this.getOptionValue(stringArray, ++n));
        }
        if (analyzerConfig == null) {
            analyzerConfig = new AnalyzerConfigImpl();
            analyzerConfig.init(this.messageList);
        }
        if ((assertionResultsOption = analyzerConfig.getAssertionResultsOption()) == null) {
            assertionResultsOption = new AssertionResultsOptionImpl();
            analyzerConfig.setAssertionResultsOption(assertionResultsOption);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("-config") || stringArray[n].equals("-c")) {
                ++n;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-verbose") || stringArray[n].equals("-v")) {
                analyzerConfig.setVerboseOption(Boolean.valueOf(this.getOptionValue(stringArray, ++n)));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-assertionResults") || stringArray[n].equals("-a")) {
                assertionResultsOption.setAssertionResultType(AssertionResultType.newInstance(this.getOptionValue(stringArray, ++n)));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-messageEntry") || stringArray[n].equals("-M")) {
                assertionResultsOption.setShowMessageEntry(Boolean.valueOf(this.getOptionValue(stringArray, ++n)));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-assertionDescription") || stringArray[n].equals("-A")) {
                assertionResultsOption.setShowAssertionDescription(Boolean.valueOf(stringArray[++n]));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-failureMessage") || stringArray[n].equals("-F")) {
                assertionResultsOption.setShowFailureMessage(Boolean.valueOf(this.getOptionValue(stringArray, ++n)));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-failureDetail") || stringArray[n].equals("-D")) {
                assertionResultsOption.setShowFailureDetail(Boolean.valueOf(this.getOptionValue(stringArray, ++n)));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-logFile") || stringArray[n].equals("-l")) {
                analyzerConfig.setLogLocation(this.getOptionValue(stringArray, ++n));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-testAssertionFile") || stringArray[n].equals("-t")) {
                analyzerConfig.setTestAssertionsDocumentLocation(this.getOptionValue(stringArray, ++n));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-reportFile") || stringArray[n].equals("-r")) {
                analyzerConfig.setReportLocation(this.getOptionValue(stringArray, ++n));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-replace") || stringArray[n].equals("-R")) {
                analyzerConfig.setReplaceReport(Boolean.valueOf(this.getOptionValue(stringArray, ++n)));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-correlationType") || stringArray[n].equals("-C")) {
                analyzerConfig.setCorrelationType(this.getOptionValue(stringArray, ++n));
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-wsdlElement") || stringArray[n].equals("-W")) {
                String string = stringArray[n];
                WSDLElementImpl wSDLElementImpl = new WSDLElementImpl();
                wSDLElementImpl.setName(this.getOptionValue(stringArray, ++n, string));
                wSDLElementImpl.setType(this.getOptionValue(stringArray, ++n, string));
                wSDLElementImpl.setNamespace(this.getOptionValue(stringArray, ++n, string));
                if (!stringArray[n].startsWith("-")) {
                    wSDLElementImpl.setParentElementName(this.getOptionValue(stringArray, ++n, string));
                }
                if (wSDLReference != null) {
                    wSDLReference.setWSDLElement(wSDLElementImpl);
                } else if (uDDIReference != null) {
                    uDDIReference.setWSDLElement(wSDLElementImpl);
                } else {
                    throw new IllegalArgumentException(this.getMessage("config10", "The -wsdlElement option must appear after the -wsdlURI or -uddiKey options."));
                }
                analyzerConfig.setWSDLReference(wSDLReference);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-serviceLocation") || stringArray[n].equals("-S")) {
                ++n;
                if (wSDLReference != null) {
                    wSDLReference.setServiceLocation(this.getOptionValue(stringArray, n));
                    continue;
                }
                if (uDDIReference != null) {
                    uDDIReference.setServiceLocation(this.getOptionValue(stringArray, n));
                    continue;
                }
                throw new IllegalArgumentException(this.getMessage("config11", "The -serviceLocation option must appear after the -wsdlURI or -uddiKey options."));
            }
            if (stringArray[n].equalsIgnoreCase("-wsdlURI") || stringArray[n].equals("-W")) {
                ++n;
                if (wSDLReference == null) {
                    wSDLReference = new WSDLReferenceImpl();
                }
                wSDLReference.setWSDLLocation(this.getOptionValue(stringArray, n));
                analyzerConfig.setWSDLReference(wSDLReference);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-uddiKeyType") || stringArray[n].equals("-K")) {
                ++n;
                if (uDDIReference == null) {
                    uDDIReference = new UDDIReferenceImpl();
                }
                uDDIReference.setKeyType(this.getOptionValue(stringArray, n));
                analyzerConfig.setUDDIReference(uDDIReference);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-uddiKey") || stringArray[n].equals("-k")) {
                ++n;
                if (uDDIReference == null) {
                    uDDIReference = new UDDIReferenceImpl();
                }
                uDDIReference.setKey(this.getOptionValue(stringArray, n));
                analyzerConfig.setUDDIReference(uDDIReference);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-inquiryURL") || stringArray[n].equals("-i")) {
                ++n;
                if (uDDIReference == null) {
                    uDDIReference = new UDDIReferenceImpl();
                }
                uDDIReference.setInquiryURL(this.getOptionValue(stringArray, n));
                analyzerConfig.setUDDIReference(uDDIReference);
                continue;
            }
            throw new IllegalArgumentException(this.getMessage("config12", stringArray[n], "The specified option is not supported:"));
        }
        if (analyzerConfig.getAddStyleSheet() == null) {
            AddStyleSheetImpl addStyleSheetImpl = new AddStyleSheetImpl();
            addStyleSheetImpl.setHref("../common/xsl/report.xsl");
            addStyleSheetImpl.setType("text/xsl");
            addStyleSheetImpl.setComment(true);
            analyzerConfig.setAddStyleSheet(addStyleSheetImpl);
        }
        this.setConfig(analyzerConfig);
        if (bl) {
            this.checkConfigOptions();
        }
    }

    private void checkConfigOptions() throws WSIException {
        if (this.isWSDLReferenceSet() && this.isUDDIReferenceSet()) {
            throw new IllegalArgumentException(this.getMessage("config04", "Can not specify both the WSDL reference and UDDI reference options"));
        }
        String string = this.getTestAssertionsDocumentLocation();
        if (string == null) {
            throw new IllegalArgumentException(this.getMessage("config16", "Test assertion document location must be specified."));
        }
        if (!Utils.fileExists(string)) {
            throw new IllegalArgumentException(this.getMessage("config14", string, "Could not find test assertion document.  Specified file location:"));
        }
        string = this.getLogLocation();
        if (string != null && !Utils.fileExists(string)) {
            throw new IllegalArgumentException(this.messageList.getMessage("config02", string, "Could not find log file:"));
        }
        if (this.getWSDLReference() != null && (string = this.getWSDLReference().getWSDLLocation()) != null && !Utils.fileExists(string)) {
            throw new IllegalArgumentException(this.messageList.getMessage("config03", string, "Could not find WSDL file:"));
        }
        File file = null;
        try {
            file = new File(this.getReportLocation());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(this.messageList.getMessage("config17", "Could not get report file location."));
        }
        if (file.exists() && !this.getReplaceReport()) {
            throw new IllegalArgumentException(this.messageList.getMessage("config15", "Report file already exists and replace option was not specified."));
        }
        if (!(this.correlationType == null || this.correlationType.equals("endpoint") || this.correlationType.equals("namespace") || this.correlationType.equals("operation"))) {
            throw new IllegalArgumentException(this.messageList.getMessage("config18", "Invalid correlation type specified."));
        }
    }

    private String getOptionValue(String[] stringArray, int n) throws WSIException {
        return this.getOptionValue(stringArray, n, stringArray[n - 1]);
    }

    private String getOptionValue(String[] stringArray, int n, String string) throws WSIException {
        if (n >= stringArray.length) {
            throw new IllegalArgumentException(this.getMessage("config13", string, "Option did not contain a value.  Specified option:"));
        }
        if (stringArray[n].startsWith("-")) {
            throw new IllegalArgumentException(this.getMessage("config13", string, "Option did not contain a value.  Specified option:"));
        }
        return stringArray[n];
    }

    private String getMessage(String string, String string2) {
        return this.getMessage(string, null, string2);
    }

    private String getMessage(String string, String string2, String string3) {
        String string4 = string3;
        if (this.messageList != null) {
            string4 = this.messageList.getMessage(string, string2, string3);
        } else if (string2 != null) {
            string4 = string4 + " " + string2 + ".";
        }
        return string4;
    }
}

