/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;

public abstract class BaseSerializerFactory
implements SerializerFactory {
    static Vector mechanisms = null;
    protected Class serClass = null;
    protected Serializer ser = null;
    protected QName xmlType = null;
    protected Class javaType = null;
    protected Constructor serClassConstructor = null;
    protected Method getSerializer = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$lang$String;

    public BaseSerializerFactory(Class serClass) {
        this.serClass = serClass;
    }

    public BaseSerializerFactory(Class serClass, QName xmlType, Class javaType) {
        this(serClass);
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.serClassConstructor = this.getConstructor(serClass);
        this.getSerializer = this.getSerializerMethod(javaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.xml.rpc.encoding.Serializer getSerializerAs(String mechanismType) throws JAXRPCException {
        BaseSerializerFactory baseSerializerFactory = this;
        synchronized (baseSerializerFactory) {
            if (this.ser == null) {
                this.ser = this.getSerializerAsInternal(mechanismType);
            }
            return this.ser;
        }
    }

    protected Serializer getSerializerAsInternal(String mechanismType) throws JAXRPCException {
        Serializer serializer = this.getSpecialized(mechanismType);
        if (serializer == null) {
            serializer = this.getGeneralPurpose(mechanismType);
        }
        try {
            if (serializer == null) {
                serializer = (Serializer)this.serClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new JAXRPCException(Messages.getMessage("CantGetSerializer", this.serClass.getName()), (Throwable)e);
        }
        return serializer;
    }

    protected Serializer getGeneralPurpose(String mechanismType) {
        if (this.javaType != null && this.xmlType != null && this.serClassConstructor != null) {
            try {
                return (Serializer)this.serClassConstructor.newInstance(this.javaType, this.xmlType);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
        }
        return null;
    }

    private Constructor getConstructor(Class clazz) {
        try {
            return clazz.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected Serializer getSpecialized(String mechanismType) {
        if (this.javaType != null && this.xmlType != null && this.getSerializer != null) {
            try {
                return (Serializer)this.getSerializer.invoke(null, mechanismType, this.javaType, this.xmlType);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
        }
        return null;
    }

    private Method getSerializerMethod(Class clazz) {
        Method method;
        block5: {
            method = null;
            try {
                method = clazz.getMethod("getSerializer", class$java$lang$String == null ? (class$java$lang$String = BaseSerializerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (method != null) break block5;
            try {
                Class helper = ClassUtils.forName(clazz.getName() + "_Helper");
                method = helper.getMethod("getSerializer", class$java$lang$String == null ? (class$java$lang$String = BaseSerializerFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            }
            catch (NoSuchMethodException e) {
            }
            catch (ClassNotFoundException e) {}
        }
        return method;
    }

    public Iterator getSupportedMechanismTypes() {
        if (mechanisms == null) {
            mechanisms = new Vector();
            mechanisms.add("Axis SAX Mechanism");
        }
        return mechanisms.iterator();
    }

    public QName getXMLType() {
        return this.xmlType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public static SerializerFactory createFactory(Class factory, Class javaType, QName xmlType) {
        SerializerFactory sf;
        block13: {
            sf = null;
            try {
                Method method = factory.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                sf = (SerializerFactory)method.invoke(null, javaType, xmlType);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            if (sf == null) {
                try {
                    Constructor constructor = factory.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = BaseSerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = BaseSerializerFactory.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                    sf = (SerializerFactory)constructor.newInstance(javaType, xmlType);
                }
                catch (NoSuchMethodException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            if (sf != null) break block13;
            try {
                sf = (SerializerFactory)factory.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {}
        }
        return sf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

