/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import jcifs.util.LogStream;
import jcifs.util.transport.Request;
import jcifs.util.transport.Response;
import jcifs.util.transport.TransportException;

public abstract class Transport
implements Runnable {
    static int id = 0;
    static LogStream log = LogStream.getInstance();
    int state = 0;
    String name = "Transport" + id++;
    Thread thread;
    TransportException te;
    protected HashMap response_map = new HashMap(4);
    public Object setupDiscoLock = new Object();

    public static int readn(InputStream in, byte[] b, int off, int len) throws IOException {
        int i;
        int n = -5;
        for (i = 0; i < len && (n = in.read(b, off + i, len - i)) > 0; i += n) {
        }
        return i;
    }

    protected abstract void makeKey(Request var1) throws IOException;

    protected abstract Request peekKey() throws IOException;

    protected abstract void doSend(Request var1) throws IOException;

    protected abstract void doRecv(Response var1) throws IOException;

    protected abstract void doSkip() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendrecv(Request request, Response response, long timeout) throws IOException {
        HashMap hashMap = this.response_map;
        synchronized (hashMap) {
            this.makeKey(request);
            response.isReceived = false;
            try {
                this.response_map.put(request, response);
                this.doSend(request);
                response.expiration = System.currentTimeMillis() + timeout;
                while (!response.isReceived) {
                    this.response_map.wait(timeout);
                    timeout = response.expiration - System.currentTimeMillis();
                    if (timeout > 0L) continue;
                    throw new TransportException(this.name + " timedout waiting for response to " + request);
                }
            }
            catch (IOException ioe) {
                if (LogStream.level > 2) {
                    ioe.printStackTrace(log);
                }
                try {
                    this.disconnect(true);
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace(log);
                }
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw new TransportException(ie);
            }
            finally {
                this.response_map.remove(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        while (this.thread == Thread.currentThread()) {
            try {
                Request key = this.peekKey();
                if (key == null) {
                    throw new IOException("end of stream");
                }
                HashMap hashMap = this.response_map;
                synchronized (hashMap) {
                    Response response = (Response)this.response_map.get(key);
                    if (response == null) {
                        if (LogStream.level > 2) {
                            log.println("Invalid key, skipping message");
                        }
                        this.doSkip();
                    } else {
                        this.doRecv(response);
                        response.isReceived = true;
                        this.response_map.notifyAll();
                    }
                }
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                boolean hard = true;
                if (LogStream.level > 2) {
                    ex.printStackTrace(log);
                }
                if (msg != null && msg.equals("Read timed out")) {
                    hard = false;
                }
                try {
                    this.disconnect(hard);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(log);
                }
            }
        }
    }

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect(boolean var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(long timeout) throws TransportException {
        switch (this.state) {
            case 0: {
                break;
            }
            case 3: {
                return;
            }
            case 4: {
                this.state = 0;
                throw new TransportException("Connection in error", this.te);
            }
            default: {
                throw new TransportException("Invalid state: " + this.state);
            }
        }
        this.state = 1;
        this.te = null;
        this.thread = new Thread((Runnable)this, this.name);
        this.thread.setDaemon(true);
        Thread thread = this.thread;
        synchronized (thread) {
            this.thread.start();
            try {
                this.thread.wait(timeout);
            }
            catch (InterruptedException ie) {
                throw new TransportException(ie);
            }
            switch (this.state) {
                case 1: {
                    this.state = 0;
                    this.thread = null;
                    throw new TransportException("Connection timeout");
                }
                case 2: {
                    if (this.te != null) {
                        this.state = 4;
                        this.thread = null;
                        throw this.te;
                    }
                    this.state = 3;
                    return;
                }
            }
            this.te = new TransportException("Invalid state: " + this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean hard) throws IOException {
        Object object = this.setupDiscoLock;
        synchronized (object) {
            Transport transport = this;
            synchronized (transport) {
                switch (this.state) {
                    case 0: {
                        return;
                    }
                    case 3: {
                        if (this.response_map.size() != 0 && !hard) break;
                        this.doDisconnect(hard);
                    }
                    case 4: {
                        this.thread = null;
                        this.state = 0;
                        break;
                    }
                    default: {
                        throw new TransportException("Invalid state: " + this.state);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread;
        Thread run_thread = Thread.currentThread();
        Exception ex0 = null;
        try {
            try {
                this.doConnect();
            }
            catch (Exception ex) {
                ex0 = ex;
                Object var5_4 = null;
                Thread thread3 = run_thread;
                synchronized (thread3) {
                    if (run_thread != this.thread) {
                        if (ex0 != null) {
                            ex0.printStackTrace();
                        }
                        return;
                    }
                    if (ex0 != null) {
                        this.te = new TransportException(ex0);
                    }
                    this.state = 2;
                    run_thread.notify();
                    return;
                }
            }
            Object var5_3 = null;
            thread = run_thread;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread thread2 = run_thread;
            synchronized (thread2) {
                if (run_thread != this.thread) {
                    if (ex0 != null) {
                        ex0.printStackTrace();
                    }
                    return;
                }
                if (ex0 != null) {
                    this.te = new TransportException(ex0);
                }
                this.state = 2;
                run_thread.notify();
                throw throwable;
            }
        }
        synchronized (thread) {
            if (run_thread != this.thread) {
                if (ex0 != null) {
                    ex0.printStackTrace();
                }
                return;
            }
            if (ex0 != null) {
                this.te = new TransportException(ex0);
            }
            this.state = 2;
            run_thread.notify();
        }
        this.loop();
    }

    public String toString() {
        return this.name;
    }
}

