/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.ServerMessageBlock;

class SmbComWriteAndX
extends AndXServerMessageBlock {
    private static final int READ_ANDX_BATCH_LIMIT = Config.getInt("jcifs.smb.client.WriteAndX.ReadAndX", 1);
    private static final int CLOSE_BATCH_LIMIT = Config.getInt("jcifs.smb.client.WriteAndX.Close", 1);
    private int fid;
    private int writeMode;
    private int remaining;
    private int dataLength;
    private int dataOffset;
    private int off;
    private byte[] b;
    private long offset;

    SmbComWriteAndX() {
        super(null);
        this.command = (byte)47;
    }

    SmbComWriteAndX(int fid, long offset, int remaining, byte[] b, int off, int len, ServerMessageBlock andx) {
        super(andx);
        this.fid = fid;
        this.offset = offset;
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.dataLength = len;
        this.command = (byte)47;
    }

    void setParam(int fid, long offset, int remaining, byte[] b, int off, int len) {
        this.fid = fid;
        this.offset = offset;
        this.remaining = remaining;
        this.b = b;
        this.off = off;
        this.dataLength = len;
        this.digest = null;
    }

    int getBatchLimit(byte command) {
        if (command == 46) {
            return READ_ANDX_BATCH_LIMIT;
        }
        if (command == 4) {
            return CLOSE_BATCH_LIMIT;
        }
        return 0;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        this.dataOffset = dstIndex - this.headerStart + 26;
        SmbComWriteAndX.writeInt2(this.fid, dst, dstIndex);
        SmbComWriteAndX.writeInt4(this.offset, dst, dstIndex += 2);
        dstIndex += 4;
        for (int i = 0; i < 4; ++i) {
            dst[dstIndex++] = 0;
        }
        SmbComWriteAndX.writeInt2(this.writeMode, dst, dstIndex);
        SmbComWriteAndX.writeInt2(this.remaining, dst, dstIndex += 2);
        dstIndex += 2;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        SmbComWriteAndX.writeInt2(this.dataLength, dst, dstIndex);
        SmbComWriteAndX.writeInt2(this.dataOffset, dst, dstIndex += 2);
        SmbComWriteAndX.writeInt4(this.offset >> 32, dst, dstIndex += 2);
        return (dstIndex += 4) - start;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        System.arraycopy(this.b, this.off, dst, dstIndex, this.dataLength);
        return (dstIndex += this.dataLength) - start;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    public String toString() {
        return new String("SmbComWriteAndX[" + super.toString() + ",fid=" + this.fid + ",offset=" + this.offset + ",writeMode=" + this.writeMode + ",remaining=" + this.remaining + ",dataLength=" + this.dataLength + ",dataOffset=" + this.dataOffset + "]");
    }
}

