// NAME
//      $RCSfile: DefaultTrapContext.java,v $
// DESCRIPTION
//      [given below in javadoc format]
// DELTA
//      $Revision: 3.10 $
// CREATED
//      $Date: 2006/01/17 17:43:54 $
// COPYRIGHT
//      Westhawk Ltd
// TO DO
//

/*
 * Copyright (C) 2001 - 2006 by Westhawk Ltd
 * <a href="www.westhawk.co.uk">www.westhawk.co.uk</a>
 *
 * Permission to use, copy, modify, and distribute this software
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that
 * both the copyright notice and this permission notice appear in
 * supporting documentation.
 * This software is provided "as is" without express or implied
 * warranty.
 * author <a href="mailto:snmp@westhawk.co.uk">Tim Panton</a>
 */

package uk.co.westhawk.snmp.stack;

import java.io.*;
import java.util.*;

import uk.co.westhawk.snmp.event.*;
import uk.co.westhawk.snmp.net.*;
import uk.co.westhawk.snmp.util.*;


/**
 * The DefaultTrapContext class will enable this stack to receive traps.
 * Only one (1) instance of the DefaultTrapContext can exist. The
 * context will only start receiving (or listen for) traps when there is
 * at least one listener registered. Two kind of listeners can be added; 
 * the normal and unhandled trap listeners.
 * The normal trap listeners are added via the
 * <code>addTrapListener()</code> method, 
 * the unhandled trap listeners are added via the 
 * <code>addUnhandledTrapListener()</code>.
 *
 * <p>
 * Use one of the <code>getInstance()</code> methods to get the instance and add a trap
 * listener. This class will fire undecoded trap events, i.e. the raw
 * data is sent and no attempt is made to decode the data into a pdu.
 * </p>
 *
 * <p>
 * The SnmpContext classes provide functionality for decoded trap
 * events. These classes will register themselves to the
 * DefaultTrapContext object and only pass the event on if it matches
 * their configuration.
 * </p>
 *
 * <p>
 * <a name=note></a>
 * Note that because only one instance of this class
 * can exist, the first call of <code>getInstance()</code> will define 
 * the settings
 * (i.e. port number and socket type) for the lifetime of the stack. All
 * the subsequent calls of <code>getInstance()</code> will return the existing
 * instance, irrespective of the arguments.
 * </p>
 *
 * <p>
 * On UNIX and Linux operating systems the default port where trap are 
 * sent (i.e. <em>162</em>) can only be opened as root.
 * </p>
 *
 * <p>
 * Note, this class is now deprecated. We are (very) slowly trying to 
 * move to a more general way of receiving packets and adding agent
 * functionality. ListeningContext and ListeningContextPool allow the
 * stack to listen to more than one port. 
 * </p>
 *
 * @deprecated  As of 4_14, replaced by {@link ListeningContext} and
 * {@link ListeningContextPool}
 *
 * @see AbstractSnmpContext#addTrapListener
 * @see ListeningContext
 * @see ListeningContextPool
 *
 * @author <a href="mailto:snmp@westhawk.co.uk">Birgit Arkesteijn</a>
 * @version $Revision: 3.10 $ $Date: 2006/01/17 17:43:54 $
 */
public class DefaultTrapContext extends ListeningContext
{
    private static final String     version_id =
        "@(#)$Id: DefaultTrapContext.java,v 3.10 2006/01/17 17:43:54 birgit Exp $ Copyright Westhawk Ltd";

    private static DefaultTrapContext current = null;

/**
 * Constructor.
 * The Standard socket type will be used.
 *
 * @param port The local port where traps are received
 * @see SnmpContextBasisFace#STANDARD_SOCKET
 */
protected DefaultTrapContext(int port) throws java.io.IOException
{
    this(port, SnmpContextBasisFace.STANDARD_SOCKET);
}

/**
 * Constructor.
 *
 * The typeSocket will indicate which type of socket to use. This way
 * different handlers can be provided for Netscape or Standard JVM.
 * The Netscape implementation will make the necessary security calls
 * to access connections that are not the applet's webserver. The KVM
 * version will be for small device support (e.g. Palm Pilot).
 *
 * @param port The local port where traps are received
 * @param typeSocketA The type of socket to use.
 *
 * @see SnmpContextBasisFace#STANDARD_SOCKET
 * @see SnmpContextBasisFace#TCP_SOCKET
 * @see SnmpContextBasisFace#NETSCAPE_SOCKET
 * @see SnmpContextBasisFace#KVM_SOCKET
 */
protected DefaultTrapContext(int port, String typeSocketA)
throws java.io.IOException
{
    super(port, typeSocketA);
}


/**
 * Returns the instance of DefaultTrapContext. It will create the
 * instance if it didn't exists.
 * See <a href=#note>the note</a> above.
 */
public static synchronized DefaultTrapContext getInstance(int port) 
throws java.io.IOException 
{
    if (current == null)
    {
        current = new DefaultTrapContext(port);
    }
    return current;
}

/**
 * Returns the instance of DefaultTrapContext. It will create the
 * instance if it didn't exists.
 * See <a href=#note>the note</a> above.
 */
public static synchronized DefaultTrapContext getInstance(int port, String typeSocketA) 
throws java.io.IOException 
{
    if (current == null)
    {
        current = new DefaultTrapContext(port, typeSocketA);
    }
    return current;
}

}
