// NAME
//      $RCSfile: AsteriskChanTypeTablePdu.java,v $
// DESCRIPTION
//      [given below in javadoc format]
// DELTA
//      $Revision: 1.1 $
// CREATED
//      $Date: 2006/06/19 12:20:49 $
// COPYRIGHT
//      Westhawk Ltd
// TO DO
//

package uk.co.westhawk.examplev2c;

import uk.co.westhawk.snmp.stack.*;
import uk.co.westhawk.snmp.pdu.*;
import java.util.*;


/**
 * The class AsteriskChanTypeTablePdu.
 *
 * This file is auto generated by the StubBrowser utility, using Mibble.
 * See the uk/co/westhawk/stub/ directory.
 *
 * Make sure that you replace the package name and classname placeholders. 
 * Also, move this file to the correct package directory.
 * If these things are not done, this class will not compile correctly!!
 *
 * @version $Revision: 1.1 $ $Date: 2006/06/19 12:20:49 $
 */
public class AsteriskChanTypeTablePdu extends GetNextPdu
{
    private static final String version_id =
        "@(#)$Id: AsteriskChanTypeTablePdu.java,v 1.1 2006/06/19 12:20:49 birgit Exp $ Copyright Westhawk Ltd";

    public final static String astNumChanTypes_OID = "1.3.6.1.4.1.22736.1.5.3";
    public final static String astChanTypeIndex_OID = "1.3.6.1.4.1.22736.1.5.4.1.1";
    public final static String astChanTypeName_OID = "1.3.6.1.4.1.22736.1.5.4.1.2";
    public final static String astChanTypeDesc_OID = "1.3.6.1.4.1.22736.1.5.4.1.3";
    public final static String astChanTypeChannels_OID = "1.3.6.1.4.1.22736.1.5.4.1.7";

    public final static int NO_SCAL = 1;
    public final static int NO_COL = 4;
    public final static int NO_OID = NO_SCAL + NO_COL;


    public final static String scal_oids[] =
    {
        astNumChanTypes_OID,
    };

    public final static String col_oids[] =
    {
        astChanTypeIndex_OID,
        astChanTypeName_OID,
        astChanTypeDesc_OID,
        astChanTypeChannels_OID,
    };

    public final static String all_oids[] =
    {
        astNumChanTypes_OID,
        astChanTypeIndex_OID,
        astChanTypeName_OID,
        astChanTypeDesc_OID,
        astChanTypeChannels_OID,
    };


    protected Integer _astNumChanTypes;
    protected Integer _astChanTypeIndex;
    protected String _astChanTypeName;
    protected String _astChanTypeDesc;
    protected Long _astChanTypeChannels;

    protected boolean _invalid = false;
    protected int _tmpErrorInd = -1;
    protected int _tmpErrorStat = 0;

/**
 * Constructor.
 *
 * @param con The context of the request
 */
public AsteriskChanTypeTablePdu(SnmpContextBasisFace con)
{
    super(con);
    _invalid = false;
    _tmpErrorInd = -1;
    _tmpErrorStat = 0;
}

/**
 * Constructor that will send the first request immediately.
 *
 * @param con The context of the request
 * @param o the Observer that will be notified when the answer is
 * received
 */
public AsteriskChanTypeTablePdu(SnmpContextBasisFace con, Observer o)
throws PduException, java.io.IOException
{
    this(con);
    addOids(null);
    if (o != null)
    {
        addObserver(o);
    }
    send();
}


/**
 * The method addOids is the basis for the GetNext functionality.
 *
 * If old is null, it initialises the varbinds from all_oids.
 * If old is not null, it copies the column OIDs from the
 * old AsteriskChanTypeTablePdu object.
 * so the request continues where the previous one left.
 *
 * Note, the scalars and the columns OIDs are handled differently. The
 * scalars are always copied from the original scal_oids, only the
 * column OIDs are copied from the old
 * AsteriskChanTypeTablePdu object.
 */
public void addOids(AsteriskChanTypeTablePdu old)
{
    if (old != null)
    {
        for (int i=0; i<NO_SCAL; i++)
        {
            addOid(scal_oids[i]);
        }
        for (int i=NO_SCAL; i<NO_OID; i++)
        {
            varbind var = (varbind) old.respVarbinds.elementAt(i);
            addOid(var.getOid());
        }
    }
    else
    {
        for (int i=0; i<NO_OID; i++)
        {
            addOid(all_oids[i]);
        }
    }
}


/**
 * This method sets the column index. By doing this, the request will
 * return (only) the row after row index.
 *
 * The index parameters only applies to the column OIDs.
 * The scalars are copied from the original scal_oids.
 */
public void addOids(int index)
{
    for (int i=0; i<NO_SCAL; i++)
    {
        addOid(scal_oids[i]);
    }
    for (int i=0; i<NO_COL; i++)
    {
        addOid(col_oids[i] + "." + index);
    }
}
/**
 * The value of the request is set. This will be called by
 * Pdu.fillin().
 *
 * I check if the variables are still in range.
 * I do this because I'm only interessed in a part of the MIB. If I
 * would not do this check, I'll get the whole MIB from the starting
 * point, instead of the variables in the table.
 *
 * @param n the index of the value
 * @param a_var the value
 * @see Pdu#new_value
 */
protected void new_value(int n, varbind res)
{
    if (getErrorStatus() == AsnObject.SNMP_ERR_NOERROR)
    {
        AsnObjectId oid = res.getOid();
        AsnObject value = res.getValue();

        if (oid.toString().startsWith(all_oids[n]))
        {
            try
            {
                switch (n)
                {
                    case 0:
                        setAstNumChanTypes(value);
                        break;
                    case 1:
                        setAstChanTypeIndex(value);
                        break;
                    case 2:
                        setAstChanTypeName(value);
                        break;
                    case 3:
                        setAstChanTypeDesc(value);
                        break;
                    case 4:
                        setAstChanTypeChannels(value);
                        break;
                    default:
                        _invalid = true;
                        setTmpErrorIndex(n);
                        _tmpErrorStat = SnmpConstants.SNMP_ERR_GENERR;
                }
            }
            catch (ClassCastException exc)
            {
                _invalid = true;
                setTmpErrorIndex(n);
                _tmpErrorStat = SnmpConstants.SNMP_ERR_GENERR;
            }
        }
        else
        {
            _invalid = true;
            setTmpErrorIndex(n);
            _tmpErrorStat = SnmpConstants.SNMP_ERR_NOSUCHNAME;
        }
    }

    if (n >= NO_OID-1)
    {
        if (_invalid == true)
        {
            setErrorStatus(_tmpErrorStat);
            setErrorIndex(_tmpErrorInd);
        }
    }
}


/**
astNumChanTypes<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Number of channel types (technologies) supported.
)<br/>
*/
public void setAstNumChanTypes(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astNumChanTypes = new Integer(obj.getValue());
}
public Integer getAstNumChanTypes()
{
    return _astNumChanTypes;
}


/**
astChanTypeIndex<br/>
TYPE Integer32 ::= [UNIVERSAL 2] INTEGER (-2147483648..2147483647)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 2] INTEGER (-2147483648..2147483647)
  Access: read-only
  Status: current
  Description: Index into the table of channel types.
)<br/>
*/
public void setAstChanTypeIndex(AsnObject new_value)
{
    AsnInteger obj = (AsnInteger) new_value;
    _astChanTypeIndex = new Integer(obj.getValue());
}
public Integer getAstChanTypeIndex()
{
    return _astChanTypeIndex;
}


/**
astChanTypeName<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Unique name of the technology we are describing.
)<br/>
*/
public void setAstChanTypeName(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanTypeName = obj.toDisplayString();
}
public String getAstChanTypeName()
{
    return _astChanTypeName;
}


/**
astChanTypeDesc<br/>
TYPE DisplayString ::= TEXTUAL-CONVENTION (
  Display-Hint: 255a
  Status: current
  Description: Represents textual information taken from the NVT ASCII
               character set, as defined in pages 4, 10-11 of RFC 854.
               
               To summarize RFC 854, the NVT ASCII repertoire specifies:
               
                 - the use of character codes 0-127 (decimal)
               
                 - the graphics characters (32-126) are interpreted as
                   US ASCII
               
                 - NUL, LF, CR, BEL, BS, HT, VT and FF have the special
                   meanings specified in RFC 854
               
                 - the other 25 codes have no standard interpretation
               
                 - the sequence 'CR LF' means newline
               
                 - the sequence 'CR NUL' means carriage-return
               
                 - an 'LF' not preceded by a 'CR' means moving to the
                   same column on the next line.
               
                 - the sequence 'CR x' for any x other than LF or NUL is
                   illegal.  (Note that this also means that a string may
                   end with either 'CR LF' or 'CR NUL', but not with CR.)
               
               Any object defined using this syntax may not exceed 255
               characters in length.
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
)<br/>
OBJECT-TYPE (
  Syntax: [UNIVERSAL 4] OCTET STRING (SIZE (0..255))
  Access: read-only
  Status: current
  Description: Description of the channel type (technology).
)<br/>
*/
public void setAstChanTypeDesc(AsnObject new_value)
{
    AsnOctets obj = (AsnOctets) new_value;
    _astChanTypeDesc = obj.toDisplayString();
}
public String getAstChanTypeDesc()
{
    return _astChanTypeDesc;
}


/**
astChanTypeChannels<br/>
TYPE Gauge32 ::= [APPLICATION 2] INTEGER (0..4294967295)<br/>
OBJECT-TYPE (
  Syntax: [APPLICATION 2] INTEGER (0..4294967295)
  Access: read-only
  Status: current
  Description: Number of active channels using the current technology.
)<br/>
*/
public void setAstChanTypeChannels(AsnObject new_value)
{
    AsnUnsInteger obj = (AsnUnsInteger) new_value;
    _astChanTypeChannels = new Long(obj.getValue());
}
public Long getAstChanTypeChannels()
{
    return _astChanTypeChannels;
}


private java.net.InetAddress getInetAddress(AsnOctets obj)
{
    java.net.InetAddress iad = null;
    try
    {
        iad = java.net.InetAddress.getByAddress(obj.getBytes());
    }
    catch(java.net.UnknownHostException exc) { }
    return iad;
}


/**
 * Returns if this set of values is invalid.
 */
public boolean isInvalid()
{
    return _invalid;
}


/**
 * Sets _tmpErrorInd, but only once.
 */
private void setTmpErrorIndex(int errind)
{
    if (_tmpErrorInd == -1)
    {
        _tmpErrorInd = errind;
    }
}


public String toString()
{
    StringBuffer buffer = new StringBuffer(getClass().getName());
    buffer.append("[");
    buffer.append("astNumChanTypes=").append(_astNumChanTypes);
    buffer.append(", astChanTypeIndex=").append(_astChanTypeIndex);
    buffer.append(", astChanTypeName=").append(_astChanTypeName);
    buffer.append(", astChanTypeDesc=").append(_astChanTypeDesc);
    buffer.append(", astChanTypeChannels=").append(_astChanTypeChannels);
    buffer.append(", invalid=").append(_invalid);
    buffer.append("]");
    return buffer.toString();
}


}

