/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.TimeWindowNode;

public class TimeWindow {
    private static final String version_id = "@(#)$Id: TimeWindow.java,v 3.13 2006/02/09 14:30:19 birgit Exp $ Copyright Westhawk Ltd";
    public static final int MaxTimeDifference = 150;
    private static TimeWindow current = null;
    private Hashtable hostLookup;
    private Hashtable engineLookup;
    private long startTime;

    public TimeWindow() {
        if (current == null) {
            current = this;
            this.hostLookup = new Hashtable(5);
            this.engineLookup = new Hashtable(5);
        }
    }

    public static TimeWindow getCurrent() {
        return current;
    }

    public String getSnmpEngineId(String hostaddr, int port) {
        String key = this.getKey(hostaddr, port);
        String snmpEngineId = (String)this.hostLookup.get(key);
        return snmpEngineId;
    }

    public boolean isSnmpEngineIdKnown(String hostaddr, int port) {
        String key = this.getKey(hostaddr, port);
        return this.hostLookup.containsKey(key);
    }

    public void setSnmpEngineId(String hostaddr, int port, String snmpEngineId) {
        String key = this.getKey(hostaddr, port);
        if (AsnObject.debug > 4) {
            System.out.println();
            System.out.println(this.getClass().getName() + ".setSnmpEngineId(): hostaddr '" + hostaddr + "', port '" + port + "', snmpEngineId '" + snmpEngineId + "'" + "', key '" + key + "'");
        }
        this.hostLookup.put(key, snmpEngineId);
    }

    public boolean isEngineIdOK(String hostaddr, int port, String snmpEngineId) {
        boolean ok = true;
        String key = this.getKey(hostaddr, port);
        if (!this.hostLookup.containsKey(key)) {
            this.setSnmpEngineId(hostaddr, port, snmpEngineId);
        } else {
            String myEngineId = this.getSnmpEngineId(hostaddr, port);
            if (!myEngineId.equalsIgnoreCase(snmpEngineId)) {
                ok = false;
            }
        }
        if (AsnObject.debug > 4) {
            System.out.println();
            System.out.println(this.getClass().getName() + ".isEngineIdOK(): hostaddr '" + hostaddr + "', port '" + port + "', snmpEngineId '" + snmpEngineId + "', ok " + ok);
        }
        return ok;
    }

    public boolean isTimeLineKnown(String snmpEngineId) {
        return this.engineLookup.containsKey(snmpEngineId);
    }

    public boolean isOutsideTimeWindow(String snmpEngineId, int bootsA, int timeA) {
        boolean isOut = false;
        TimeWindowNode node = this.getTimeLine(snmpEngineId);
        if (node != null) {
            int bootsL = node.getSnmpEngineBoots();
            int timeL = node.getSnmpEngineTime();
            if (bootsA == Integer.MAX_VALUE || bootsA < bootsL || bootsA == bootsL && timeA < timeL - 150) {
                isOut = true;
            }
        } else {
            isOut = false;
        }
        return isOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTimeWindow(String snmpEngineId, int bootsA, int timeA, boolean isAuthentic) {
        boolean updated = false;
        TimeWindowNode node = this.getTimeLine(snmpEngineId);
        if (node != null) {
            if (isAuthentic) {
                int bootsL = node.getSnmpEngineBoots();
                int latestL = node.getLatestReceivedEngineTime();
                if (bootsA > bootsL || bootsA == bootsL && timeA > latestL) {
                    TimeWindow timeWindow = this;
                    synchronized (timeWindow) {
                        node.setSnmpEngineBoots(bootsA);
                        node.setSnmpEngineTime(timeA);
                        updated = true;
                    }
                }
            }
        } else if (bootsA > 0) {
            node = new TimeWindowNode(snmpEngineId, bootsA, timeA);
            this.setTimeLine(snmpEngineId, node);
        }
        if (AsnObject.debug > 4) {
            System.out.println();
            System.out.println(this.getClass().getName() + ".updateTimeWindow(): snmpEngineId '" + snmpEngineId + "', bootsA " + bootsA + ", timeA " + timeA + ", isAuthentic " + isAuthentic + ", updated " + updated);
        }
        return updated;
    }

    protected void updateTimeWindows() {
        if (this.engineLookup.size() > 0) {
            int sec;
            long now = System.currentTimeMillis();
            long milli = now - this.startTime;
            long lostMillis = milli - (long)(sec = (int)(milli / 1000L)) * 1000L;
            if (lostMillis < 0L) {
                lostMillis = 0L;
            }
            this.startTime = now - lostMillis;
            Enumeration nodes = this.engineLookup.elements();
            while (nodes.hasMoreElements()) {
                TimeWindowNode node = (TimeWindowNode)nodes.nextElement();
                node.incrementSnmpEngineTime(sec);
            }
        } else {
            this.startTime = System.currentTimeMillis();
        }
    }

    protected String getKey(String hostaddr, int port) {
        return hostaddr + ":" + port;
    }

    protected TimeWindowNode getTimeLine(String snmpEngineId) {
        this.updateTimeWindows();
        TimeWindowNode node = (TimeWindowNode)this.engineLookup.get(snmpEngineId);
        return node;
    }

    protected TimeWindowNode setTimeLine(String snmpEngineId, TimeWindowNode newNode) {
        this.updateTimeWindows();
        this.engineLookup.put(snmpEngineId, newNode);
        if (AsnObject.debug > 4) {
            System.out.println();
            System.out.println(this.getClass().getName() + ".setTimeLine(): snmpEngineId " + snmpEngineId + ", node " + newNode);
        }
        return newNode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[");
        Enumeration enum1 = this.hostLookup.keys();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String snmpEngineId = (String)this.hostLookup.get(key);
            TimeWindowNode node = (TimeWindowNode)this.engineLookup.get(snmpEngineId);
            buffer.append("\n\t(");
            if (node == null) {
                buffer.append("key=").append(key);
                buffer.append(", engineId=").append(snmpEngineId);
            } else {
                buffer.append("key=").append(key).append(", ");
                buffer.append(node.toString());
            }
            buffer.append(") ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

