/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import uk.co.westhawk.snmp.beans.UsmBeingDiscoveredBean;
import uk.co.westhawk.snmp.event.RequestPduListener;
import uk.co.westhawk.snmp.stack.AsnDecoderv3;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.GetBulkPdu;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.GetPdu;
import uk.co.westhawk.snmp.stack.InformPdu;
import uk.co.westhawk.snmp.stack.ListeningContextPool;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContextv3Basis;
import uk.co.westhawk.snmp.stack.TrapPduv2;

public class SnmpContextv3
extends SnmpContextv3Basis {
    private static final String version_id = "@(#)$Id: SnmpContextv3.java,v 3.29 2006/03/23 14:54:10 birgit Exp $ Copyright Westhawk Ltd";
    private UsmBeingDiscoveredBean myDiscBean = null;

    public SnmpContextv3(String host, int port) throws IOException {
        super(host, port);
    }

    public SnmpContextv3(String host, int port, String typeSocketA) throws IOException {
        super(host, port, typeSocketA);
    }

    public SnmpContextv3(String host, int port, String bindAddress, String typeSocketA) throws IOException {
        super(host, port, bindAddress, typeSocketA);
    }

    public void addRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        super.addRequestPduListener(l, lcontext);
        if (this.myDiscBean == null) {
            this.myDiscBean = new UsmBeingDiscoveredBean(this, this.usmAgent);
        }
        this.myDiscBean.addRequestPduListener(lcontext);
    }

    public void removeRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        super.removeRequestPduListener(l, lcontext);
        if (this.myDiscBean != null) {
            this.myDiscBean.removeRequestPduListener(lcontext);
            this.myDiscBean.freeResources();
            this.myDiscBean = null;
        }
    }

    public Pdu processIncomingPdu(byte[] message) throws DecodingException, IOException {
        IOException encryptionIOException2;
        DecodingException encryptionDecodingException2;
        IOException encryptionIOException1;
        DecodingException encryptionDecodingException1;
        Pdu pdu;
        int msgId;
        block17: {
            AsnSequence asnTopSeq;
            AsnDecoderv3 rpdu;
            byte[] copyOfMessage2;
            block16: {
                String msg = this.checkContextSanity();
                if (msg != null) {
                    throw new DecodingException(msg);
                }
                int l = message.length;
                byte[] copyOfMessage1 = new byte[l];
                copyOfMessage2 = new byte[l];
                System.arraycopy(message, 0, copyOfMessage1, 0, l);
                System.arraycopy(message, 0, copyOfMessage2, 0, l);
                rpdu = new AsnDecoderv3();
                ByteArrayInputStream in = new ByteArrayInputStream(message);
                asnTopSeq = rpdu.DecodeSNMPv3(in);
                msgId = rpdu.getMsgId(asnTopSeq);
                pdu = null;
                encryptionDecodingException1 = null;
                encryptionIOException1 = null;
                try {
                    pdu = this.processPotentialTrap(rpdu, asnTopSeq, copyOfMessage1);
                }
                catch (DecodingException exc) {
                    encryptionDecodingException1 = exc;
                    if (AsnObject.debug > 3) {
                        System.out.println(this.getClass().getName() + ".processPotentialTrap(): DecodingException: " + exc.getMessage());
                    }
                }
                catch (IOException exc) {
                    encryptionIOException1 = exc;
                    if (AsnObject.debug <= 3) break block16;
                    System.out.println(this.getClass().getName() + ".processPotentialTrap(): IOException: " + exc.getMessage());
                }
            }
            encryptionDecodingException2 = null;
            encryptionIOException2 = null;
            if (pdu == null) {
                try {
                    pdu = this.processPotentialRequest(rpdu, asnTopSeq, copyOfMessage2);
                }
                catch (DecodingException exc) {
                    encryptionDecodingException2 = exc;
                    if (AsnObject.debug > 3) {
                        System.out.println(this.getClass().getName() + ".processPotentialRequest(): DecodingException: " + exc.getMessage());
                    }
                }
                catch (IOException exc) {
                    encryptionIOException2 = exc;
                    if (AsnObject.debug <= 3) break block17;
                    System.out.println(this.getClass().getName() + ".processPotentialRequest(): IOException: " + exc.getMessage());
                }
            }
        }
        if (pdu != null) {
            pdu.snmpv3MsgId = new Integer(msgId);
        } else {
            if (encryptionIOException2 != null) {
                throw encryptionIOException2;
            }
            if (encryptionDecodingException2 != null) {
                throw encryptionDecodingException2;
            }
            if (encryptionIOException1 != null) {
                throw encryptionIOException1;
            }
            if (encryptionDecodingException1 != null) {
                throw encryptionDecodingException1;
            }
        }
        return pdu;
    }

    public Pdu processPotentialTrap(AsnDecoderv3 rpdu, AsnSequence asnTopSeq, byte[] message) throws DecodingException, IOException {
        AsnPduSequence pduSeq = rpdu.processSNMPv3(this, asnTopSeq, message, false);
        TrapPduv2 pdu = null;
        if (pduSeq != null) {
            byte type = pduSeq.getRespType();
            if (type == -89) {
                pdu = new TrapPduv2(this);
                pdu.fillin(pduSeq);
                if (AsnObject.debug > 3) {
                    System.out.println(this.getClass().getName() + ".processPotentialTrap(): PDU received with type " + pduSeq.getRespTypeString() + ". Not ignoring it!");
                }
            } else if (AsnObject.debug > 3) {
                System.out.println(this.getClass().getName() + ".processPotentialTrap(): PDU received is not TRPV2_REQ_MSG" + ". Ignoring it.");
            }
        } else if (AsnObject.debug > 3) {
            System.out.println(this.getClass().getName() + ".processPotentialTrap(): pduSeq == null" + ". Ignoring it.");
        }
        return pdu;
    }

    public Pdu processPotentialRequest(AsnDecoderv3 rpdu, AsnSequence asnTopSeq, byte[] message) throws DecodingException, IOException {
        AsnPduSequence pduSeq = rpdu.processSNMPv3(this, asnTopSeq, message, true);
        Pdu pdu = null;
        if (pduSeq != null) {
            byte type = pduSeq.getRespType();
            if (type == -96 && pduSeq.isSnmpv3Discovery()) {
                if (AsnObject.debug > 3) {
                    System.out.println(this.getClass().getName() + ".ProcessIncomingPdu(): received discovery pdu" + ". Ignoring it.");
                }
            } else {
                switch (type) {
                    case -96: {
                        pdu = new GetPdu(this);
                        pdu.fillin(pduSeq);
                        break;
                    }
                    case -95: {
                        pdu = new GetNextPdu(this);
                        pdu.fillin(pduSeq);
                        break;
                    }
                    case -93: {
                        pdu = new SetPdu(this);
                        pdu.fillin(pduSeq);
                        break;
                    }
                    case -91: {
                        pdu = new GetBulkPdu(this);
                        pdu.fillin(pduSeq);
                        break;
                    }
                    case -90: {
                        pdu = new InformPdu(this);
                        pdu.fillin(pduSeq);
                        break;
                    }
                    default: {
                        if (AsnObject.debug <= 3) break;
                        System.out.println(this.getClass().getName() + ".processPotentialRequest(): PDU received with type " + pduSeq.getRespTypeString() + ". Ignoring it.");
                    }
                }
                if (pdu != null && AsnObject.debug > 3) {
                    System.out.println(this.getClass().getName() + ".processPotentialRequest(): PDU received with type " + pduSeq.getRespTypeString() + ". Not ignoring it!");
                }
            }
        } else if (AsnObject.debug > 3) {
            System.out.println(this.getClass().getName() + "..processPotentialRequest(): pduSeq == null" + ". Ignoring it.");
        }
        return pdu;
    }

    public Object clone() throws CloneNotSupportedException {
        SnmpContextv3 clContext = null;
        try {
            clContext = new SnmpContextv3(this.hostname, this.hostPort, this.bindAddr, this.typeSocket);
            clContext = (SnmpContextv3)this.cloneParameters(clContext);
        }
        catch (IOException exc) {
            throw new CloneNotSupportedException("IOException " + exc.getMessage());
        }
        return clContext;
    }
}

