/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.event.RawPduListener;
import uk.co.westhawk.snmp.stack.ListeningContext;
import uk.co.westhawk.snmp.stack.ListeningContextFace;

public class ListeningContextPool
implements ListeningContextFace {
    private static final String version_id = "@(#)$Id: ListeningContextPool.java,v 3.5 2006/02/09 14:30:19 birgit Exp $ Copyright Westhawk Ltd";
    protected static Hashtable contextPool;
    protected ListeningContext context = null;
    protected String socketType;
    protected String bindAddr;
    protected int hostPort;

    public ListeningContextPool(int port) {
        this(port, null, "Standard");
    }

    public ListeningContextPool(int port, String bindAddress) {
        this(port, bindAddress, "Standard");
    }

    public ListeningContextPool(int port, String bindAddress, String typeSocket) {
        ListeningContextPool.initPools();
        this.hostPort = port;
        this.bindAddr = bindAddress;
        this.socketType = typeSocket;
        this.context = this.getMatchingContext();
    }

    private static synchronized void initPools() {
        if (contextPool == null) {
            contextPool = new Hashtable(5);
        }
    }

    public int getPort() {
        return this.hostPort;
    }

    public String getBindAddress() {
        return this.bindAddr;
    }

    public String getTypeSocket() {
        return this.socketType;
    }

    public int getMaxRecvSize() {
        int res = 1300;
        if (this.context != null) {
            res = this.context.getMaxRecvSize();
        }
        return res;
    }

    public void setMaxRecvSize(int no) {
        if (this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.setMaxRecvSize(no);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        String hashKey = this.getHashKey();
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            int count = 0;
            Item item = (Item)contextPool.get(hashKey);
            if (item != null) {
                count = item.getCounter();
                item.setCounter(--count);
            }
            if (count <= 0) {
                contextPool.remove(hashKey);
                if (this.context != null) {
                    this.context.destroy();
                    this.context = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPool() {
        Hashtable copyOfPool = null;
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            Hashtable hashtable2 = contextPool;
            synchronized (hashtable2) {
                copyOfPool = (Hashtable)contextPool.clone();
            }
            contextPool.clear();
        }
        this.context = null;
        Enumeration keys = copyOfPool.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Item item = (Item)copyOfPool.get(key);
            if (item == null) continue;
            ListeningContext cntxt = item.getContext();
            cntxt.destroy();
        }
        copyOfPool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListeningContext getMatchingContext() {
        Item item = null;
        ListeningContext newContext = null;
        String hashKey = this.getHashKey();
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            int count = 0;
            if (contextPool.containsKey(hashKey)) {
                item = (Item)contextPool.get(hashKey);
                newContext = item.getContext();
                count = item.getCounter();
            } else {
                newContext = new ListeningContext(this.hostPort, this.bindAddr, this.socketType);
                item = new Item(newContext);
                contextPool.put(hashKey, item);
            }
            item.setCounter(++count);
        }
        return newContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpContexts(String title) {
        Hashtable copyOfPool = null;
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            copyOfPool = (Hashtable)contextPool.clone();
        }
        System.out.println(title + " " + copyOfPool.size());
        Enumeration keys = copyOfPool.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Item item = (Item)copyOfPool.get(key);
            if (item == null) continue;
            int count = item.getCounter();
            ListeningContext cntxt = item.getContext();
            System.out.println("\tcontext: " + key + ", count: " + count + ", index: " + i + ", " + cntxt.toString());
            if (cntxt == this.context) {
                System.out.println("\t\tcurrent context");
            }
            ++i;
        }
    }

    public String getHashKey() {
        String str = this.hostPort + "_" + this.bindAddr + "_" + this.socketType;
        return str;
    }

    public void addRawPduListener(RawPduListener l) throws IOException {
        if (this.context != null) {
            this.context.addRawPduListener(l);
        }
    }

    public void removeRawPduListener(RawPduListener l) {
        if (this.context != null) {
            this.context.removeRawPduListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRawPduListenerFromPool(RawPduListener l) {
        Hashtable copyOfPool = null;
        if (contextPool != null) {
            Hashtable hashtable = contextPool;
            synchronized (hashtable) {
                copyOfPool = (Hashtable)contextPool.clone();
            }
            Enumeration keys = copyOfPool.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Item item = (Item)copyOfPool.get(key);
                if (item == null) continue;
                ListeningContext cntxt = item.getContext();
                cntxt.removeRawPduListener(l);
            }
        }
    }

    public void addUnhandledRawPduListener(RawPduListener l) throws IOException {
        if (this.context != null) {
            this.context.addUnhandledRawPduListener(l);
        }
    }

    public void removeUnhandledRawPduListener(RawPduListener l) {
        if (this.context != null) {
            this.context.removeUnhandledRawPduListener(l);
        }
    }

    public String toString() {
        String res = "";
        if (this.context != null) {
            res = this.context.toString();
        }
        return res;
    }

    class Item {
        private ListeningContext context = null;
        private int counter = 0;

        Item(ListeningContext con) {
            this.context = con;
            this.counter = 0;
        }

        ListeningContext getContext() {
            return this.context;
        }

        int getCounter() {
            return this.counter;
        }

        void setCounter(int i) {
            this.counter = i;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Item[");
            buffer.append("context=").append(this.context.toString());
            buffer.append(", counter=").append(this.counter);
            buffer.append("]");
            return buffer.toString();
        }
    }
}

