/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.EncodingException;

public class AsnObjectId
extends AsnObject {
    private static final String version_id = "@(#)$Id: AsnObjectId.java,v 3.20 2006/02/02 15:54:25 birgit Exp $ Copyright Westhawk Ltd";
    private long[] value = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 674L, 10889L, 2L, 1L, 0L};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    AsnObjectId() {
    }

    AsnObjectId(InputStream in, int len) throws IOException {
        byte[] data = new byte[len];
        if (len != in.read(data, 0, len)) {
            throw new IOException("AsnObjectId(): Not enough data");
        }
        int sids = 1;
        int off = 0;
        while (off < len) {
            if (data[off] >= 0) {
                ++sids;
            }
            ++off;
        }
        this.value = new long[sids];
        if (len > 0) {
            this.value[0] = data[0] / 40;
            this.value[1] = data[0] % 40;
        }
        int off2 = 1;
        int idx = 2;
        while (idx < this.value.length) {
            long tval = 0L;
            do {
                tval <<= 7;
                tval |= (long)(data[off2] & 0x7F);
            } while (data[off2++] < 0);
            this.value[idx] = tval;
            ++idx;
        }
    }

    public AsnObjectId(String s) throws IllegalArgumentException {
        this.value = this.toArrayOfLongs(s);
    }

    public AsnObjectId(long[] oida) {
        int len = oida.length;
        this.value = new long[len];
        System.arraycopy(oida, 0, this.value, 0, len);
    }

    private long[] toArrayOfLongs(String s) throws IllegalArgumentException {
        long[] oidArray = new long[]{};
        if (s != null && s.length() > 0) {
            StringTokenizer tok = new StringTokenizer(s, ".");
            int count = tok.countTokens();
            oidArray = new long[count];
            int n = 0;
            while (tok.hasMoreTokens()) {
                try {
                    String num = tok.nextToken();
                    Long val = Long.valueOf(num);
                    oidArray[n] = val;
                    ++n;
                }
                catch (NumberFormatException exc) {
                    throw new IllegalArgumentException("AsnObjectId(): Bad OID '" + s + "' " + exc.getMessage());
                }
                catch (NoSuchElementException exc) {
                    // empty catch block
                }
            }
        } else {
            throw new IllegalArgumentException("AsnObjectId(): Bad OID '" + s + "' ");
        }
        return oidArray;
    }

    public boolean startsWith(AsnObjectId prefix) {
        boolean sw = true;
        if (prefix.value.length < this.value.length) {
            int pos = 0;
            while (pos < prefix.value.length && sw) {
                sw = prefix.value[pos] == this.value[pos];
                ++pos;
            }
        } else {
            sw = false;
        }
        return sw;
    }

    public void add(long sub_oid) {
        int size = this.value.length;
        long[] tmp_value = this.value;
        this.value = new long[size + 1];
        System.arraycopy(tmp_value, 0, this.value, 0, size);
        this.value[size] = sub_oid;
    }

    public void add(long[] sub_oid) {
        int size1 = this.value.length;
        int size2 = sub_oid.length;
        long[] tmp_value = this.value;
        this.value = new long[size1 + size2];
        System.arraycopy(tmp_value, 0, this.value, 0, size1);
        System.arraycopy(sub_oid, 0, this.value, size1, size2);
    }

    public void add(String s) throws IllegalArgumentException {
        long[] sub_oid = this.toArrayOfLongs(s);
        this.add(sub_oid);
    }

    int size() throws EncodingException {
        int len;
        if (this.value.length > 1) {
            len = this.getSIDLen(this.value[0] * 40L + this.value[1]);
            int idx = 2;
            while (idx < this.value.length) {
                len += this.getSIDLen(this.value[idx]);
                ++idx;
            }
        } else if (this.value.length == 1) {
            len = this.getSIDLen(this.value[0] * 40L);
        } else if (this.value.length == 0) {
            len = this.getSIDLen(0L);
        } else {
            throw new EncodingException("Negative numbers cannot be encoded as OID sub-identifiers");
        }
        return len;
    }

    void write(OutputStream out, int pos) throws IOException, EncodingException {
        this.AsnBuildHeader(out, (byte)6, this.size());
        if (AsnObject.debug > 10) {
            System.out.println("\tAsnObjectId(): value = " + this.toString() + ", pos = " + pos);
        }
        if (this.value.length > 1) {
            this.EncodeSID(out, this.value[0] * 40L + this.value[1]);
            int idx = 2;
            while (idx < this.value.length) {
                this.EncodeSID(out, this.value[idx]);
                ++idx;
            }
        } else if (this.value.length == 1) {
            this.EncodeSID(out, this.value[0] * 40L);
        } else {
            this.EncodeSID(out, 0L);
        }
    }

    private int getSIDLen(long value) {
        int count = 1;
        while ((value >>= 7) != 0L) {
            ++count;
        }
        return count;
    }

    private void EncodeSID(OutputStream out, long value) throws IOException {
        int mask = 15;
        int count = 0;
        mask = 15;
        count = 28;
        while (count > 0) {
            if ((value >> count & (long)mask) != 0L) break;
            mask = 127;
            count -= 7;
        }
        while (count >= 0) {
            out.write((byte)(value >> count & (long)mask | (long)(count > 0 ? 128 : 0)));
            mask = 127;
            count -= 7;
        }
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        return this.toString(this.value);
    }

    public String toString(long[] v) {
        StringBuffer buffer = new StringBuffer("");
        int n = 0;
        while (n < v.length - 1 && n < 100) {
            if (v[n] <= 9L) {
                int i = (int)v[n];
                buffer.append(digits[i]);
            } else {
                buffer.append(v[n]);
            }
            buffer.append(".");
            ++n;
        }
        if (v.length - 1 > 100) {
            buffer.append("[.. cut ..].");
        }
        buffer.append(v[v.length - 1]);
        return buffer.toString();
    }

    public int getSize() {
        return this.value.length;
    }

    public synchronized long getElementAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.value.length) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.value.length);
        }
        try {
            return this.value[index];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public long[] getOid() {
        int len = this.value.length;
        long[] oida = new long[len];
        System.arraycopy(this.value, 0, oida, 0, len);
        return oida;
    }

    public long[] getSubOid(int beginIndex, int endIndex) throws ArrayIndexOutOfBoundsException {
        int len1 = this.value.length;
        if (beginIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(beginIndex + " < 0");
        }
        if (endIndex > len1) {
            throw new ArrayIndexOutOfBoundsException(endIndex + " > " + len1);
        }
        if (beginIndex > endIndex) {
            throw new ArrayIndexOutOfBoundsException(beginIndex + " > " + endIndex);
        }
        int len2 = endIndex - beginIndex;
        long[] oida = new long[len2];
        System.arraycopy(this.value, beginIndex, oida, 0, len2);
        return oida;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof AsnObjectId) {
            AsnObjectId anotherOid = (AsnObjectId)anObject;
            int n = this.value.length;
            if (n == anotherOid.value.length) {
                long[] v1 = this.value;
                long[] v2 = anotherOid.value;
                int i = 0;
                int j = 0;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        if (h == 0) {
            int off = 0;
            long[] val = this.value;
            int len = this.value.length;
            int i = 0;
            while (i < len) {
                long l = val[off++];
                int hi = (int)(l ^ l >>> 32);
                h = 31 * h + hi;
                ++i;
            }
        }
        return h;
    }
}

