/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import uk.co.westhawk.snmp.net.ContextSocketFace;
import uk.co.westhawk.snmp.net.StreamPortItem;

public class TCPSocket
implements ContextSocketFace {
    static final String version_id = "@(#)$Id: TCPSocket.java,v 1.7 2006/03/23 14:54:09 birgit Exp $ Copyright Westhawk Ltd";
    private ServerSocket serverSoc = null;
    private Socket clientSoc = null;
    private InetAddress sendToHostAddr;
    private int sendToHostPort;
    private InetAddress receiveFromHostAddr;
    private int receiveFromHostPort;
    private InetAddress locBindAddr;

    public void create(int port, String bindAddr) throws IOException {
        this.receiveFromHostPort = this.sendToHostPort = port;
        try {
            this.locBindAddr = null;
            if (bindAddr != null) {
                this.locBindAddr = InetAddress.getByName(bindAddr);
            }
            this.serverSoc = new ServerSocket(this.sendToHostPort, 50, this.locBindAddr);
        }
        catch (SocketException exc) {
            String str = "Socket problem " + exc.getMessage();
            throw new IOException(str);
        }
    }

    public void create(String host, int port, String bindAddr) throws IOException {
        this.receiveFromHostPort = this.sendToHostPort = port;
        try {
            this.receiveFromHostAddr = this.sendToHostAddr = InetAddress.getByName(host);
            this.locBindAddr = null;
            if (bindAddr != null) {
                this.locBindAddr = InetAddress.getByName(bindAddr);
            }
            this.clientSoc = new Socket(this.sendToHostAddr, this.sendToHostPort, this.locBindAddr, 0);
        }
        catch (SocketException exc) {
            String str = "Socket problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (UnknownHostException exc) {
            String str = "Cannot find host " + exc.getMessage();
            throw new IOException(str);
        }
    }

    public String getReceivedFromHostAddress() {
        String res = null;
        if (this.receiveFromHostAddr != null) {
            res = this.receiveFromHostAddr.getHostAddress();
        }
        return res;
    }

    public String getSendToHostAddress() {
        String res = null;
        if (this.sendToHostAddr != null) {
            res = this.sendToHostAddr.getHostAddress();
        }
        return res;
    }

    public String getLocalSocketAddress() {
        SocketAddress sa;
        String res = null;
        if (this.serverSoc != null) {
            SocketAddress sa2 = this.serverSoc.getLocalSocketAddress();
            if (sa2 != null) {
                res = sa2.toString();
            }
        } else if (this.clientSoc != null && (sa = this.clientSoc.getLocalSocketAddress()) != null) {
            res = sa.toString();
        }
        return res;
    }

    public String getRemoteSocketAddress() {
        String res = null;
        if (this.clientSoc != null) {
            SocketAddress sa = this.clientSoc.getRemoteSocketAddress();
            if (sa != null) {
                res = sa.toString();
            }
        } else if (this.serverSoc != null) {
            // empty if block
        }
        return res;
    }

    public StreamPortItem receive(int maxRecvSize) throws IOException {
        StreamPortItem item = null;
        if (this.serverSoc != null) {
            byte[] data = new byte[maxRecvSize];
            this.serverSoc.setSoTimeout(1000);
            Socket newSocket = this.serverSoc.accept();
            InputStream newSocketIn = newSocket.getInputStream();
            newSocketIn.read(data, 0, data.length);
            this.receiveFromHostAddr = newSocket.getInetAddress();
            this.receiveFromHostPort = newSocket.getPort();
            ByteArrayInputStream in = null;
            in = new ByteArrayInputStream(data, 0, data.length);
            item = new StreamPortItem(this.receiveFromHostAddr.getHostAddress(), this.receiveFromHostPort, in);
            newSocketIn.close();
            newSocket.close();
            newSocketIn = null;
            newSocket = null;
        } else if (this.clientSoc != null) {
            byte[] data = new byte[maxRecvSize];
            this.clientSoc.setSoTimeout(1000);
            InputStream cin = this.clientSoc.getInputStream();
            cin.read(data, 0, data.length);
            this.receiveFromHostAddr = this.clientSoc.getInetAddress();
            this.receiveFromHostPort = this.clientSoc.getPort();
            ByteArrayInputStream in = null;
            in = new ByteArrayInputStream(data, 0, data.length);
            item = new StreamPortItem(this.receiveFromHostAddr.getHostAddress(), this.receiveFromHostPort, in);
        }
        return item;
    }

    public void send(byte[] packet) throws IOException {
        if (this.clientSoc != null) {
            OutputStream out = this.clientSoc.getOutputStream();
            out.write(packet);
            out.flush();
        }
    }

    public void close() {
        try {
            if (this.clientSoc != null) {
                this.clientSoc.close();
            }
        }
        catch (IOException exc) {
            // empty catch block
        }
        try {
            if (this.serverSoc != null) {
                this.serverSoc.close();
            }
        }
        catch (IOException exc) {
            // empty catch block
        }
        this.serverSoc = null;
        this.clientSoc = null;
    }
}

