/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import uk.co.westhawk.snmp.net.ContextSocketFace;
import uk.co.westhawk.snmp.net.StreamPortItem;

public class KvmSocket
implements ContextSocketFace {
    private String dgurl;
    private DatagramConnection soc = null;
    private boolean haveWrittenPacket = false;
    private String sendToHostAddr = null;
    private int sendToHostPort;

    public void create(int port, String bindAddr) throws IOException {
        this.sendToHostPort = port;
        this.dgurl = "datagram://:" + this.sendToHostPort;
        try {
            this.soc = (DatagramConnection)Connector.open((String)this.dgurl);
        }
        catch (IllegalArgumentException exc) {
            String str = "IllegalArgument problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (ConnectionNotFoundException exc) {
            String str = "ConnectionNotFound problem " + exc.getMessage();
            throw new IOException(str);
        }
    }

    public void create(String host, int port, String bindAddr) throws IOException {
        this.sendToHostPort = port;
        this.sendToHostAddr = host;
        this.dgurl = "datagram://" + this.sendToHostAddr + ":" + this.sendToHostPort;
        try {
            this.soc = (DatagramConnection)Connector.open((String)this.dgurl);
        }
        catch (IllegalArgumentException exc) {
            String str = "IllegalArgument problem " + exc.getMessage();
            throw new IOException(str);
        }
        catch (ConnectionNotFoundException exc) {
            String str = "ConnectionNotFound problem " + exc.getMessage();
            throw new IOException(str);
        }
    }

    public String getSendToHostAddress() {
        return this.sendToHostAddr;
    }

    public String getReceivedFromHostAddress() {
        return this.sendToHostAddr;
    }

    public String getLocalSocketAddress() {
        return null;
    }

    public String getRemoteSocketAddress() {
        return null;
    }

    public StreamPortItem receive(int maxRecvSize) throws IOException {
        StreamPortItem item = null;
        if (this.soc != null) {
            while (!this.haveWrittenPacket) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            byte[] data = new byte[maxRecvSize];
            Datagram p = this.soc.newDatagram(data, maxRecvSize);
            this.soc.receive(p);
            String address = p.getAddress();
            ByteArrayInputStream in = null;
            in = new ByteArrayInputStream(p.getData(), 0, p.getLength());
            item = new StreamPortItem(p.getAddress(), -1, in);
            p = null;
        }
        return item;
    }

    public void send(byte[] packet) throws IOException {
        if (this.soc != null) {
            this.haveWrittenPacket = true;
            Datagram pack = this.soc.newDatagram(packet, packet.length, this.dgurl);
            this.soc.send(pack);
        }
    }

    public void close() {
        block2: {
            if (this.soc == null) break block2;
            try {
                this.soc.close();
                this.soc = null;
            }
            catch (IOException exc) {}
        }
    }
}

