/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import uk.co.westhawk.snmp.pdu.DiscoveryPdu;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextv3;
import uk.co.westhawk.snmp.stack.TimeWindow;
import uk.co.westhawk.snmp.stack.varbind;

public class UsmDiscoveryBean {
    private static final String version_id = "@(#)$Id: UsmDiscoveryBean.java,v 1.17 2006/06/19 10:48:15 birgit Exp $ Copyright Westhawk Ltd";
    private SnmpContextv3 context;
    private String userName = null;
    private String userAuthPassword = null;
    private String userPrivPassword = null;
    private int authProtocol;

    public UsmDiscoveryBean(String host, int port) throws IOException {
        this(host, port, null, "Standard");
    }

    public UsmDiscoveryBean(String host, int port, String bindAddr, String typeSocketA) throws IOException {
        this.context = new SnmpContextv3(host, port, bindAddr, typeSocketA);
    }

    public void setAuthenticationDetails(String newUserName, String newUserPassword, int protocol) {
        this.userName = newUserName;
        this.userAuthPassword = newUserPassword;
        this.authProtocol = protocol;
    }

    public void setPrivacyDetails(String newUserPassword) {
        this.userPrivPassword = newUserPassword;
    }

    public void startDiscovery() throws PduException, IOException {
        block5: {
            try {
                this.discoveryEngineId();
            }
            catch (PduException exc) {
                this.freeResources();
                throw new PduException("Engine ID discovery: " + exc.getMessage());
            }
            try {
                this.discoveryTimeLine();
            }
            catch (PduException exc) {
                TimeWindow tWindow = TimeWindow.getCurrent();
                String engineId = tWindow.getSnmpEngineId(this.context.getSendToHostAddress(), this.context.getPort());
                if (tWindow.isTimeLineKnown(engineId)) break block5;
                this.freeResources();
                throw new PduException("Timeline discovery: " + exc.getMessage());
            }
        }
        if (AsnObject.debug > 4) {
            System.out.println(this.getClass().getName() + ".startDiscovery(): " + "Done, context " + this.context.toString());
        }
        this.freeResources();
    }

    public void freeResources() {
        this.context.destroy();
        this.context = null;
    }

    protected void discoveryEngineId() throws PduException, IOException {
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.context.getHost(), this.context.getPort());
        if (engineId == null) {
            if (AsnObject.debug > 4) {
                System.out.println(this.getClass().getName() + ".discoveryEngineId(): " + "Starting discovery Engine ID ...");
            }
            this.context.setUserName("");
            this.context.setUseAuthentication(false);
            this.context.setUsePrivacy(false);
            this.context.setContextEngineId(new byte[0]);
            this.context.setContextName("");
            DiscoveryPdu pdu = new DiscoveryPdu(this.context);
            pdu.send();
            pdu.waitForSelf();
            varbind[] vars = pdu.getResponseVarbinds();
        }
    }

    protected void discoveryTimeLine() throws PduException, IOException {
        String engineId;
        TimeWindow tWindow = TimeWindow.getCurrent();
        if (!tWindow.isTimeLineKnown(engineId = tWindow.getSnmpEngineId(this.context.getSendToHostAddress(), this.context.getPort())) && this.userName != null) {
            if (AsnObject.debug > 4) {
                System.out.println(this.getClass().getName() + ".discoveryTimeLine(): " + "Starting discovery Timeline ...");
            }
            this.context.setUserName(this.userName);
            this.context.setUserAuthenticationPassword(this.userAuthPassword);
            this.context.setUseAuthentication(true);
            this.context.setAuthenticationProtocol(this.authProtocol);
            this.context.setContextEngineId(new byte[0]);
            this.context.setContextName("");
            if (this.userPrivPassword != null) {
                this.context.setUsePrivacy(true);
                this.context.setUserPrivacyPassword(this.userPrivPassword);
            } else {
                this.context.setUsePrivacy(false);
            }
            DiscoveryPdu pdu = new DiscoveryPdu(this.context);
            pdu.send();
            pdu.waitForSelf();
            varbind[] vars = pdu.getResponseVarbinds();
            if (AsnObject.debug > 4) {
                System.out.println("Did discovery time line");
            }
        }
    }
}

