/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.pdu.InterfaceGetNextPdu;
import uk.co.westhawk.snmp.stack.PduException;

public class OneInterfaceBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: OneInterfaceBean.java,v 1.14 2006/01/25 18:08:56 birgit Exp $ Copyright Westhawk Ltd";
    private InterfaceGetNextPdu pdu;
    private InterfaceGetNextPdu prev;
    private boolean isPduInFlight;
    private Date lastUpdateDate = null;
    private int index = 1;
    private String descr = "";
    private String operState = "";
    private long speed = -1L;

    public OneInterfaceBean() {
    }

    public OneInterfaceBean(String h, int p) {
        this(h, p, null);
    }

    public OneInterfaceBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public void setIndex(int i) {
        if (this.index != i) {
            this.index = i;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getDescription() {
        return this.descr;
    }

    public String getOperStatusString() {
        return this.operState;
    }

    public long getSpeed() {
        return this.speed;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void action() {
        if (this.isHostPortReachable()) {
            this.lastUpdateDate = new Date();
            this.isPduInFlight = false;
            this.setRunning(true);
        }
    }

    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isPduInFlight) {
                this.isPduInFlight = true;
                this.prev = this.pdu;
                try {
                    this.pdu = new InterfaceGetNextPdu(this.context);
                    this.pdu.addObserver(this);
                    this.pdu.addOids(this.index - 1);
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException ix) {
                // empty catch block
            }
        }
    }

    public void update(Observable obs, Object ov) {
        if (this.pdu.getErrorStatus() == 0) {
            if (this.prev != null) {
                this.speed = this.pdu.getSpeed(this.prev);
            }
            this.descr = this.pdu.getIfDescr();
            this.operState = this.pdu.getIfOperStatusStr();
            this.lastUpdateDate = new Date();
            this.isPduInFlight = false;
            this.firePropertyChange("Interface", null, null);
        }
    }
}

