/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import uk.co.westhawk.snmp.beans.SNMPBean;
import uk.co.westhawk.snmp.beans.ethernet;
import uk.co.westhawk.snmp.beans.memory;
import uk.co.westhawk.snmp.beans.user;

public class NcdPerfDataBean
extends SNMPBean
implements PropertyChangeListener {
    private static final String version_id = "@(#)$Id: NcdPerfDataBean.java,v 1.12 2006/01/17 17:43:53 birgit Exp $ Copyright Westhawk Ltd";
    public static final String speedPropertyName = "Speed";
    public static final String memoryPropertyName = "Memory";
    public static final String userPropertyName = "User";
    public static final String messagePropertyName = "Message";
    public static final String noLogin = "no one is logged in";
    public static final String noName = "not available";
    private ethernet ethernetData;
    private user userData;
    private memory memoryData;
    private Date lastUpdateDate = null;
    private int interval = 3000;
    private long speed = -1L;
    private long memoryAvail = -1L;
    private String userName = "";

    public long getSpeed() {
        return this.speed;
    }

    public long getMemory() {
        return this.memoryAvail;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUpdateInterval() {
        return this.interval;
    }

    public void setUpdateInterval(int i) {
        if (this.interval != i) {
            this.interval = i;
        }
    }

    public void setUpdateInterval(String i) {
        try {
            int iNo = Integer.valueOf(i.trim());
            this.setUpdateInterval(iNo);
        }
        catch (NumberFormatException exp) {}
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void action() {
        if (this.isHostPortReachable()) {
            this.lastUpdateDate = new Date();
            if (this.ethernetData != null) {
                this.ethernetData.setRunning(false);
            }
            if (this.userData != null) {
                this.userData.setRunning(false);
            }
            if (this.memoryData != null) {
                this.memoryData.setRunning(false);
            }
            this.ethernetData = new ethernet(this.host, this.port, this.community, this.interval, this.context);
            this.userData = new user(this.host, this.port, this.community, this.interval, this.context);
            this.memoryData = new memory(this.host, this.port, this.community, this.interval, this.context);
            this.ethernetData.addPropertyChangeListener(this);
            this.userData.addPropertyChangeListener(this);
            this.memoryData.addPropertyChangeListener(this);
        }
    }

    protected void setMessage(String st) {
        this.message = st;
        this.firePropertyChange(messagePropertyName, null, this.message);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object src = e.getSource();
        Object oldV = e.getOldValue();
        Object newV = e.getNewValue();
        String propName = e.getPropertyName();
        if (propName.equals(messagePropertyName)) {
            this.setMessage((String)newV);
        } else {
            if (src == this.ethernetData) {
                this.speed = (Long)newV;
            } else if (src == this.userData) {
                this.userName = (String)newV;
            } else if (src == this.memoryData) {
                this.memoryAvail = (Long)newV;
            }
            this.firePropertyChange(e.getPropertyName(), oldV, newV);
        }
    }
}

