/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import uk.co.westhawk.snmp.beans.SNMPBean;
import uk.co.westhawk.snmp.pdu.UpSincePdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;

public class IsHostReachableBean
extends SNMPBean
implements Observer {
    private static final String version_id = "@(#)$Id: IsHostReachableBean.java,v 1.14 2006/01/26 12:38:59 birgit Exp $ Copyright Westhawk Ltd";
    private UpSincePdu pdu;
    private Date upSince = null;
    private boolean isReachable = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");

    public IsHostReachableBean() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public IsHostReachableBean(String h, int p) {
        this(h, p, null);
    }

    public IsHostReachableBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public Date getUpSinceDate() {
        return this.upSince;
    }

    protected void setUpSinceDate(Date d) {
        this.upSince = d;
    }

    public boolean isReachable() {
        return this.isReachable;
    }

    protected void setReachable(boolean b) {
        boolean old = this.isReachable;
        this.isReachable = b;
        this.firePropertyChange("Reachable", new Boolean(old), new Boolean(this.isReachable));
    }

    public void waitForSelfAction() throws PduException, IOException {
        this.action(true);
    }

    public void action() throws PduException, IOException {
        this.action(false);
    }

    protected void action(boolean wait) throws PduException, IOException {
        block7: {
            if (this.host == null || this.host.length() <= 0 || this.port <= 0) break block7;
            try {
                if (this.context != null) {
                    this.context.destroy();
                }
                this.context = new SnmpContext(this.host, this.port, this.bindAddr, this.socketType);
                this.context.setCommunity(this.community);
                this.setMessage("Connection to host " + this.host + " is made succesfully");
                if (wait) {
                    this.pdu = new UpSincePdu(this.context, null);
                    if (this.pdu.waitForSelf()) {
                        this.update(this.pdu, null);
                    } else {
                        this.setMessage("No SNMP Response from " + this.host);
                    }
                    break block7;
                }
                this.pdu = new UpSincePdu(this.context, this);
            }
            catch (IOException exc) {
                this.setMessage("IOException: " + exc.getMessage());
                this.setReachable(false);
            }
            catch (RuntimeException exc) {
                this.setMessage("RuntimeException: " + exc.getMessage());
                this.setReachable(false);
            }
        }
    }

    public void update(Observable obs, Object ov) {
        this.pdu = (UpSincePdu)obs;
        if (this.pdu.getErrorStatus() == 0) {
            this.setUpSinceDate(this.pdu.getDate());
            this.setMessage("Host " + this.host + " is up since " + this.dateFormat.format(this.getUpSinceDate()));
            this.setReachable(true);
        } else {
            this.setUpSinceDate(null);
            this.setMessage("SNMP Response: " + this.pdu.getErrorStatusString());
            this.setReachable(false);
        }
    }

    public void freeResources() {
        if (this.context != null) {
            this.context.destroy();
            this.context = null;
        }
    }
}

