/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.tablelayout;

import uk.co.westhawk.tablelayout.TableLayout;
import uk.co.westhawk.tablelayout.TableVecRec;

public abstract class TableVec {
    private static final String version_id = "@(#)$Id: TableVec.java,v 3.2 2002/07/18 16:10:34 birgit Exp $ Copyright West Consulting bv";
    static final int TBL_VEC_MINIMIZE = 1;
    static final int TBL_VEC_LOCK = 2;
    static final int TBL_VEC_NOGROW = 3;
    static final boolean DO_ACTUAL = true;
    static final boolean DO_PREFERRED = false;
    public TableVecRec[] vec;
    public TableLayout parent;
    public int size;

    public abstract void minimize();

    public abstract int totalSize();

    public abstract int getPreferredSize();

    public abstract int layoutSize(boolean var1);

    public TableVecRec elementAt(int index) {
        if (index < 0 || index > this.size - 1) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.vec[index];
    }

    public void adjust(int change) {
        int amt;
        if (change == 0) {
            return;
        }
        int can_change_pref = 0;
        int can_change = 0;
        int total_pref = 0;
        int too_big_pref = 0;
        int too_big = 0;
        int too_small = 0;
        int vec_inx = 0;
        while (vec_inx < this.size) {
            total_pref += this.vec[vec_inx].pref_value;
            if (change > 0) {
                if ((this.vec[vec_inx].options & 2) == 0) {
                    ++can_change;
                    can_change_pref += this.vec[vec_inx].pref_value;
                }
                if (this.vec[vec_inx].value < this.vec[vec_inx].pref_value) {
                    ++too_small;
                }
            } else if (this.vec[vec_inx].value > this.vec[vec_inx].pref_value) {
                ++too_big;
                too_big_pref += this.vec[vec_inx].pref_value;
            }
            ++vec_inx;
        }
        if (change > 0) {
            int amt2;
            int remaining = change;
            int still_too_small = 1;
            while (still_too_small != 0) {
                still_too_small = 0;
                vec_inx = 0;
                while (vec_inx < this.size) {
                    if (this.vec[vec_inx].value < this.vec[vec_inx].pref_value) {
                        amt2 = total_pref == 0 ? change / (too_small != 0 ? too_small : this.size) : change * this.vec[vec_inx].pref_value / total_pref;
                        if (amt2 == 0) {
                            amt2 = 1;
                        } else if (remaining < amt2) {
                            amt2 = remaining;
                        }
                        if (this.vec[vec_inx].value + amt2 < this.vec[vec_inx].pref_value) {
                            this.vec[vec_inx].value += amt2;
                            ++still_too_small;
                        } else {
                            amt2 = this.vec[vec_inx].pref_value - this.vec[vec_inx].value;
                            this.vec[vec_inx].value = this.vec[vec_inx].pref_value;
                        }
                        if ((remaining -= amt2) <= 0) {
                            return;
                        }
                    }
                    ++vec_inx;
                }
                change = remaining;
            }
            if (can_change == 0) {
                can_change_pref = total_pref;
            }
            while (true) {
                vec_inx = 0;
                while (vec_inx < this.size) {
                    if (can_change == 0 || (this.vec[vec_inx].options & 2) == 0) {
                        amt2 = can_change_pref == 0 ? change / (can_change != 0 ? can_change : this.size) : change * this.vec[vec_inx].pref_value / can_change_pref;
                        if (amt2 == 0) {
                            amt2 = 1;
                        } else if (remaining < amt2) {
                            amt2 = remaining;
                        }
                        this.vec[vec_inx].value += amt2;
                        if ((remaining -= amt2) <= 0) {
                            return;
                        }
                    }
                    ++vec_inx;
                }
                change = remaining;
            }
        }
        int remaining = change = -change;
        int still_too_big = too_big;
        while (still_too_big != 0) {
            still_too_big = 0;
            vec_inx = 0;
            while (vec_inx < this.size) {
                if (this.vec[vec_inx].value > this.vec[vec_inx].pref_value) {
                    amt = too_big_pref == 0 ? change / (too_big != 0 ? too_big : this.size) : change * this.vec[vec_inx].pref_value / too_big_pref;
                    if (amt == 0) {
                        amt = 1;
                    } else if (remaining < amt) {
                        amt = remaining;
                    }
                    if (this.vec[vec_inx].value - amt < this.vec[vec_inx].pref_value) {
                        amt = this.vec[vec_inx].value - this.vec[vec_inx].pref_value;
                        this.vec[vec_inx].value = this.vec[vec_inx].pref_value;
                    } else {
                        this.vec[vec_inx].value -= amt;
                        ++still_too_big;
                    }
                    if ((remaining -= amt) <= 0) {
                        return;
                    }
                }
                ++vec_inx;
            }
            change = remaining;
        }
        if (this.size == 1) {
            vec_inx = 0;
            this.vec[vec_inx].value -= change;
            if (this.vec[vec_inx].value < 1) {
                this.vec[vec_inx].value = 1;
            }
        } else {
            int num_larger_than_1 = 1;
            while (num_larger_than_1 != 0) {
                num_larger_than_1 = 0;
                vec_inx = 0;
                while (vec_inx < this.size) {
                    amt = total_pref == 0 ? change / this.size : change * this.vec[vec_inx].pref_value / total_pref;
                    if (amt == 0) {
                        amt = 1;
                    } else if (remaining < amt) {
                        amt = remaining;
                    }
                    if (amt < this.vec[vec_inx].value) {
                        this.vec[vec_inx].value -= amt;
                        ++num_larger_than_1;
                    } else {
                        amt = this.vec[vec_inx].value - 1;
                        this.vec[vec_inx].value = 1;
                    }
                    if ((remaining -= amt) <= 0) {
                        return;
                    }
                    ++vec_inx;
                }
                change = remaining;
            }
        }
    }

    public void computeOffsets(int margin, int gap) {
        int offset = margin;
        int i = 0;
        while (i < this.size) {
            this.vec[i].offset = offset;
            offset = offset + this.vec[i].value + gap;
            ++i;
        }
    }

    public String toString() {
        String st = new String("TableVec [ size " + this.size);
        int i = 0;
        while (i < this.size) {
            st = String.valueOf(st) + "\n" + this.vec[i].toString();
            ++i;
        }
        st = String.valueOf(st) + " ]";
        return st;
    }
}

