/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.nothread.trap;

import java.io.IOException;
import uk.co.westhawk.snmp.pdu.PassiveTrapPduv2;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.PassiveSnmpContextv2c;
import uk.co.westhawk.snmp.stack.PduException;

public class SendTrap {
    private static final String version_id = "@(#)$Id: SendTrap.java,v 1.3 2006/01/17 17:43:54 birgit Exp $ Copyright Westhawk Ltd";
    public static final String sysUpTime = "1.3.6.1.2.1.1.3.0";
    public static final String snmpTrapOID = "1.3.6.1.6.3.1.1.4.1.0";
    public static final String coldStart = "1.3.6.1.6.3.1.1.5.1";
    public static final String warmStart = "1.3.6.1.6.3.1.1.5.2";
    public static final String linkDown = "1.3.6.1.6.3.1.1.5.3";
    public static final String linkUp = "1.3.6.1.6.3.1.1.5.4";
    public static final String authenticationFailure = "1.3.6.1.6.3.1.1.5.5";
    public static final String egpNeighborLoss = "1.3.6.1.6.3.1.1.5.6";

    public static String doSendTrap(String host, int port, String comm, long upTime, String trapOid) {
        StringBuffer result = new StringBuffer("");
        try {
            PassiveSnmpContextv2c context = new PassiveSnmpContextv2c(host, port);
            context.setCommunity(comm);
            PassiveTrapPduv2 pdu = new PassiveTrapPduv2(context);
            pdu.addOid(sysUpTime, (AsnObject)new AsnUnsInteger(upTime));
            pdu.addOid(snmpTrapOID, (AsnObject)new AsnObjectId(trapOid));
            pdu.send();
            context.destroy();
            result.append("OK");
        }
        catch (IOException exc) {
            result.append("IOException ").append(exc.getMessage());
        }
        catch (PduException exc) {
            result.append("PduException ").append(exc.getMessage());
        }
        catch (Exception exc) {
            result.append("Exception ").append(exc.getMessage());
        }
        int len = result.length();
        if (len > 500) {
            result.setLength(500);
        }
        return result.toString();
    }
}

