/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.schema;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * ArcheTypeSpec
 *
 * @since   Aug. 17, 1999
 * @version Jan. 18, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ArcheTypeSpec implements Constants {
    protected ArcheTypeRef[] refinements_;
    // ContentType
    protected DataTypeRef contentTypeDataTypeRef_;
    protected ContentModel contentTypeContentModel_;
    protected ModelGroupRef contentTypeModelGroupRef_;
    // attrDecl | attrGroupRef
    protected Object[] attrs_;	// XXX
    protected int model_;
    protected boolean export_;

    public ArcheTypeSpec(Element root) {
	SmartElement sm = new SmartElement(root);
	Element[] refines = sm.getElements("refines");
	if (refines != null) {
	    Element[] arches
		= sm.getElements("archetypeRef");
	    refinements_ = new ArcheTypeRef[arches.length];
	    for (int i = 0;i < arches.length;i++) {
		refinements_[i] = ArcheTypeRef.create(arches[i]);
	    }
	}
    }

    public static ArcheTypeSpec create(Element root) {
	return (new ArcheTypeSpec(root));
    }
}
