package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNChoice</b> is generated by Relaxer based on relaxNg.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="choice">
 *   <tag name="choice"/>
 *   <sequence>
 *     <hedgeRef label="elementHedge" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="choice"&gt;
 *   &lt;tag name="choice"/&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="elementHedge" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Tue Jan 22 17:40:38 JST 2002)
 * @author  Relaxer 0.16.1b (http://www.relaxer.org)
 */
public class RNChoice implements java.io.Serializable, IRNSContainer, IRNode, IRNElementHedgeChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    // List<IRNElementHedgeChoice>
    private java.util.List elementHedge_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNChoice</code>.
     *
     */
    public RNChoice() {
    }

    /**
     * Creates a <code>RNChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNChoice(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNChoice(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNChoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNChoice(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNChoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        elementHedge_.clear();
        while (!stack.isEmptyElement()) {
            if (RNAttribute.isMatch(stack)) {
                addElementHedge(new RNAttribute(stack));
            } else if (RNElement.isMatch(stack)) {
                addElementHedge(new RNElement(stack));
            } else if (RNData.isMatch(stack)) {
                addElementHedge(new RNData(stack));
            } else if (RNRef.isMatch(stack)) {
                addElementHedge(new RNRef(stack));
            } else if (RNText.isMatch(stack)) {
                addElementHedge(new RNText(stack));
            } else if (RNValue.isMatch(stack)) {
                addElementHedge(new RNValue(stack));
            } else if (RNGroup.isMatch(stack)) {
                addElementHedge(new RNGroup(stack));
            } else if (RNOptional.isMatch(stack)) {
                addElementHedge(new RNOptional(stack));
            } else if (RNChoice.isMatch(stack)) {
                addElementHedge(new RNChoice(stack));
            } else if (RNZeroOrMore.isMatch(stack)) {
                addElementHedge(new RNZeroOrMore(stack));
            } else if (RNOneOrMore.isMatch(stack)) {
                addElementHedge(new RNOneOrMore(stack));
            } else if (RNNotAllowed.isMatch(stack)) {
                addElementHedge(new RNNotAllowed(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "choice");
        rNSContext_.setupNamespace(element);
        int size;
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @return IRNElementHedgeChoice[]
     */
    public final IRNElementHedgeChoice[] getElementHedge() {
        IRNElementHedgeChoice[] array = new IRNElementHedgeChoice[elementHedge_.size()];
        return ((IRNElementHedgeChoice[])elementHedge_.toArray(array));
    }

    /**
     * Sets the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @param elementHedge
     */
    public final void setElementHedge(IRNElementHedgeChoice[] elementHedge) {
        this.elementHedge_.clear();
        this.elementHedge_.addAll(java.util.Arrays.asList(elementHedge));
        for (int i = 0;i < elementHedge.length;i++) {
            elementHedge[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @param elementHedge
     */
    public final void setElementHedge(IRNElementHedgeChoice elementHedge) {
        this.elementHedge_.clear();
        this.elementHedge_.add(elementHedge);
        if (elementHedge != null) {
            elementHedge.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @param elementHedge
     */
    public final void addElementHedge(IRNElementHedgeChoice elementHedge) {
        this.elementHedge_.add(elementHedge);
        if (elementHedge != null) {
            elementHedge.setParentRNode(this);
        }
    }

    /**
     * Gets number of the IRNElementHedgeChoice property <b>elementHedge</b>.
     *
     * @return int
     */
    public final int getElementHedgeCount() {
        return (elementHedge_.size());
    }

    /**
     * Gets the IRNElementHedgeChoice property <b>elementHedge</b> by index.
     *
     * @param index
     * @return IRNElementHedgeChoice
     */
    public final IRNElementHedgeChoice getElementHedge(int index) {
        return ((IRNElementHedgeChoice)elementHedge_.get(index));
    }

    /**
     * Sets the IRNElementHedgeChoice property <b>elementHedge</b> by index.
     *
     * @param index
     * @param elementHedge
     */
    public final void setElementHedge(int index, IRNElementHedgeChoice elementHedge) {
        this.elementHedge_.set(index, elementHedge);
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.append(">");
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        buffer.print(">");
        size = this.elementHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNElementHedgeChoice value = (IRNElementHedgeChoice)this.elementHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.print(">");
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(elementHedge_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNChoice</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "choice")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (RNAttribute.isMatchHungry(target)) {
            } else if (RNElement.isMatchHungry(target)) {
            } else if (RNData.isMatchHungry(target)) {
            } else if (RNRef.isMatchHungry(target)) {
            } else if (RNText.isMatchHungry(target)) {
            } else if (RNValue.isMatchHungry(target)) {
            } else if (RNGroup.isMatchHungry(target)) {
            } else if (RNOptional.isMatchHungry(target)) {
            } else if (RNChoice.isMatchHungry(target)) {
            } else if (RNZeroOrMore.isMatchHungry(target)) {
            } else if (RNOneOrMore.isMatchHungry(target)) {
            } else if (RNNotAllowed.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNChoice</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNChoice</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
