/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * IEVisitor
 *
 * @since   Feb. 17, 2000
 * @version Dec.  9, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public interface IEVisitor {
    boolean enter(EElementNode node);
    boolean enter(EElementSlotNode node);
    boolean enter(EContentNode node);
    boolean enter(EElementRefNode node);
    boolean enter(EContentRefNode node);
    boolean enter(EElementSlot node);
    boolean enter(EAttributeSlot node);
    boolean enter(ESequenceNode node);
    boolean enter(EChoiceNode node);
    boolean enter(EMixedNode node);
    boolean enter(EExternalRefNode node);
    boolean enter(EExternalRoleRefNode node);
    boolean enter(ENode node);
    void leave(EElementNode node);
    void leave(EElementSlotNode node);
    void leave(EContentNode node);
    void leave(EElementRefNode node);
    void leave(EContentRefNode node);
    void leave(EElementSlot node);
    void leave(EAttributeSlot node);
    void leave(ESequenceNode node);
    void leave(EChoiceNode node);
    void leave(EMixedNode node);
    void leave(EExternalRefNode node);
    void leave(EExternalRoleRefNode node);
    void leave(ENode node);
}
