/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EElementRefNode
 *
 * @since   Jan. 10, 2000
 * @version Dec. 15, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class EElementRefNode extends ENode implements IEOccurs {
    private EElementNode elementNode_;
    private int occurs_;

    public EElementRefNode(EElementNode ref) {
	this(ref, OCCURS_ONE);
    }

    public EElementRefNode(EElementNode ref, int occurs) {
	super("elementRef");
	elementNode_ = ref;
	occurs_ = occurs;
	setAttribute("tag", ref.getElementName());
	setAttribute("href", "#element" + ref.getId());
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public EElementRefNode(EElementRefNode erNode) {
	this(erNode.getElementNode(), erNode.getOccurs());
    }

    public final EElementNode getElementNode() {
	return (elementNode_);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }

    public synchronized void lockWrite() throws InterruptedException {
	super.lockWrite();
	elementNode_.lockWrite();
    }

    public synchronized void unlockWrite() throws InterruptedException {
	elementNode_.unlockWrite();
	super.unlockWrite();
    }

    public synchronized boolean isLockWrite() {
	return (elementNode_.isLockWrite());
    }

    public synchronized void lockRead() throws InterruptedException {
	super.lockRead();
	elementNode_.lockRead();
    }

    public synchronized void unlockRead() throws InterruptedException {
	elementNode_.unlockRead();
	super.unlockRead();
    }

    public synchronized boolean isLockRead() {
	return (elementNode_.isLockRead());
    }
}
