/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.RRelax;
import jp.gr.java_conf.jaba2.xml.relax.raw.RGrammar;
import jp.gr.java_conf.jaba2.xml.relax.raw.RModule;
import jp.gr.java_conf.jaba2.xml.relax.raw.RContentRule;
import jp.gr.java_conf.jaba2.xml.relax.raw.RAttListPattern;
import jp.gr.java_conf.jaba2.xml.relaxng.RNGModule;

/**
 * CRelax
 *
 * @since   Dec. 20, 1999
 * @version Jun. 20, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class CRelax {
    private CGrammar grammar_;
    private List modules_ = new ArrayList();

    public CRelax(RRelax rrelax) {
	RModule[] rmodules = rrelax.getModules();
	RNGModule[] ngModules = rrelax.getNgModules();
	for (int i = 0;i < rmodules.length;i++) {
	    CModule cModule = new CModule(rmodules[i]);
	    cModule.setFileURI(rmodules[i].getFileURI());
	    cModule.setBaseURI(rmodules[i].getBaseURI());
	    modules_.add(cModule);
	}
	for (int i = 0;i < ngModules.length;i++) {
	    CModule cModule = ngModules[i].getCModule();
	    modules_.add(cModule);
	}
	RGrammar grammar = rrelax.getGrammar();
	if (grammar != null) {
	    grammar_ = new CGrammar(grammar);
	    _importHedgeRule(grammar);
	    _importAttPool(grammar);
	}
    }

    private void _importHedgeRule(RGrammar grammar) {
	RContentRule[] rules = grammar.getContentRules();
	for (int i = 0;i < rules.length;i++) {
	    RContentRule rule = rules[i];
	    String ruleNamespace = rule.getNamespace();
	    for (int j = 0;j < modules_.size();j++) {
		CModule module = (CModule)modules_.get(j);
		if (ruleNamespace.equals(module.getTargetNamespace())) {
		    module.addContentRule(rule);
		}
	    }
	}
    }

    private void _importAttPool(RGrammar grammar) {
	RAttListPattern[] patterns = grammar.getAttListPatterns();
	for (int i = 0;i < patterns.length;i++) {
	    RAttListPattern pattern = patterns[i];
	    String patternNamespace = pattern.getNamespace();
	    for (int j = 0;j < modules_.size();j++) {
		CModule module = (CModule)modules_.get(j);
		if (patternNamespace.equals(module.getTargetNamespace())) {
		    module.addAttListPattern(pattern);
		}
	    }
	}
    }

    public CGrammar getGrammar() {
	return (grammar_);
    }

    public CModule[] getModules() {
	CModule[] modules = new CModule[modules_.size()];
	return ((CModule[])modules_.toArray(modules));
    }
}
